/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.common.PassAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.player.ai.ComputerPlayer;
import org.apache.log4j.Logger;

public class MCTSPlayer
extends ComputerPlayer {
    private static final Logger logger = Logger.getLogger(MCTSPlayer.class);
    private NextAction nextAction;

    public MCTSPlayer(UUID id) {
        super(id);
    }

    public MCTSPlayer(MCTSPlayer player) {
        super((ComputerPlayer)player);
        this.nextAction = player.nextAction;
    }

    public MCTSPlayer copy() {
        return new MCTSPlayer(this);
    }

    protected List<ActivatedAbility> getPlayableAbilities(Game game) {
        List playables = this.getPlayable(game, true);
        playables.add(new PassAbility());
        return playables;
    }

    public List<Ability> getPlayableOptions(Game game) {
        ArrayList<Ability> all = new ArrayList<Ability>();
        List<ActivatedAbility> playables = this.getPlayableAbilities(game);
        for (ActivatedAbility ability : playables) {
            List options = game.getPlayer(this.playerId).getPlayableOptions((Ability)ability, game);
            if (options.isEmpty()) {
                if (!ability.getManaCosts().getVariableCosts().isEmpty()) {
                    this.simulateVariableCosts((Ability)ability, all, game);
                    continue;
                }
                all.add((Ability)ability);
                continue;
            }
            for (Ability option : options) {
                if (!ability.getManaCosts().getVariableCosts().isEmpty()) {
                    this.simulateVariableCosts(option, all, game);
                    continue;
                }
                all.add(option);
            }
        }
        return all;
    }

    protected void simulateVariableCosts(Ability ability, List<Ability> options, Game game) {
        int numAvailable = this.getAvailableManaProducers(game).size() - ability.getManaCosts().manaValue();
        int start = 0;
        if (!(ability instanceof SpellAbility)) {
            if (numAvailable == 0) {
                return;
            }
            start = 1;
        }
        for (int i = start; i < numAvailable; ++i) {
            Ability newAbility = ability.copy();
            newAbility.addManaCostsToPay((ManaCost)new GenericManaCost(i));
            options.add(newAbility);
        }
    }

    public List<List<UUID>> getAttacks(Game game) {
        ArrayList<List<UUID>> engagements = new ArrayList<List<UUID>>();
        List attackersList = super.getAvailableAttackers(game);
        int powerElements = (int)Math.pow(2.0, attackersList.size());
        StringBuilder binary = new StringBuilder();
        for (int i = powerElements - 1; i >= 0; --i) {
            binary.setLength(0);
            binary.append(Integer.toBinaryString(i));
            while (binary.length() < attackersList.size()) {
                binary.insert(0, '0');
            }
            ArrayList<UUID> engagement = new ArrayList<UUID>();
            for (int j = 0; j < attackersList.size(); ++j) {
                if (binary.charAt(j) != '1') continue;
                engagement.add(((Permanent)attackersList.get(j)).getId());
            }
            engagements.add(engagement);
        }
        return engagements;
    }

    public List<List<List<UUID>>> getBlocks(Game game) {
        ArrayList<List<List<UUID>>> engagements = new ArrayList<List<List<UUID>>>();
        int numGroups = game.getCombat().getGroups().size();
        if (numGroups == 0) {
            return engagements;
        }
        ArrayList<List<UUID>> engagement = new ArrayList<List<UUID>>();
        for (int i = 0; i < numGroups; ++i) {
            engagement.add(new ArrayList());
        }
        engagements.add(engagement);
        List blockers = this.getAvailableBlockers(game);
        this.addBlocker(game, engagement, blockers, engagements);
        return engagements;
    }

    private List<List<UUID>> copyEngagement(List<List<UUID>> engagement) {
        ArrayList<List<UUID>> newEngagement = new ArrayList<List<UUID>>();
        for (List<UUID> group : engagement) {
            newEngagement.add(new ArrayList<UUID>(group));
        }
        return newEngagement;
    }

    protected void addBlocker(Game game, List<List<UUID>> engagement, List<Permanent> blockers, List<List<List<UUID>>> engagements) {
        if (blockers.isEmpty()) {
            return;
        }
        int numGroups = game.getCombat().getGroups().size();
        Permanent blocker = blockers.get(0);
        List remaining = this.remove(blockers, blocker);
        for (int i = 0; i < numGroups; ++i) {
            if (!((CombatGroup)game.getCombat().getGroups().get(i)).canBlock(blocker, game)) continue;
            List<List<UUID>> newEngagement = this.copyEngagement(engagement);
            newEngagement.get(i).add(blocker.getId());
            engagements.add(newEngagement);
            this.addBlocker(game, newEngagement, remaining, engagements);
        }
        this.addBlocker(game, engagement, remaining, engagements);
    }

    public NextAction getNextAction() {
        return this.nextAction;
    }

    public void setNextAction(NextAction action) {
        this.nextAction = action;
    }

    public boolean priority(Game game) {
        game.pause();
        this.nextAction = NextAction.PRIORITY;
        return false;
    }

    public void selectAttackers(Game game, UUID attackingPlayerId) {
        game.pause();
        this.nextAction = NextAction.SELECT_ATTACKERS;
    }

    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        game.pause();
        this.nextAction = NextAction.SELECT_BLOCKERS;
    }

    public static enum NextAction {
        PRIORITY,
        SELECT_ATTACKERS,
        SELECT_BLOCKERS;

    }
}

