/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.TriggeredAbility;
import mage.abilities.common.PassAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.cards.Card;
import mage.cards.Cards;
import mage.choices.Choice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.match.MatchPlayer;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.player.ai.MCTSPlayer;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public final class SimulatedPlayerMCTS
extends MCTSPlayer {
    private boolean isSimulatedPlayer;
    private int actionCount = 0;
    private static final Logger logger = Logger.getLogger(SimulatedPlayerMCTS.class);

    public SimulatedPlayerMCTS(Player originalPlayer, boolean isSimulatedPlayer) {
        super(originalPlayer.getId());
        this.isSimulatedPlayer = isSimulatedPlayer;
        this.matchPlayer = new MatchPlayer(originalPlayer.getMatchPlayer(), (Player)this);
    }

    public SimulatedPlayerMCTS(SimulatedPlayerMCTS player) {
        super(player);
        this.isSimulatedPlayer = player.isSimulatedPlayer;
    }

    @Override
    public SimulatedPlayerMCTS copy() {
        return new SimulatedPlayerMCTS(this);
    }

    public boolean isSimulatedPlayer() {
        return this.isSimulatedPlayer;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public boolean priority(Game game) {
        boolean didSomething = false;
        Ability ability = this.getAction(game);
        if (!(ability instanceof PassAbility)) {
            didSomething = true;
        }
        this.activateAbility((ActivatedAbility)ability, game);
        ++this.actionCount;
        return didSomething;
    }

    private Ability getAction(Game game) {
        Ability ability;
        block1: {
            int amount;
            List<ActivatedAbility> playables = this.getPlayableAbilities(game);
            ability = playables.size() == 1 ? (Ability)playables.get(0) : (Ability)playables.get(RandomUtil.nextInt((int)playables.size()));
            List options = this.getPlayableOptions(ability, game);
            if (!options.isEmpty()) {
                ability = options.size() == 1 ? (Ability)options.get(0) : (Ability)options.get(RandomUtil.nextInt((int)options.size()));
            }
            if (ability.getManaCosts().getVariableCosts().isEmpty() || (amount = this.getAvailableManaProducers(game).size() - ability.getManaCosts().manaValue()) <= 0) break block1;
            ability = ability.copy();
            ability.addManaCostsToPay((ManaCost)new GenericManaCost(RandomUtil.nextInt((int)amount)));
        }
        return ability;
    }

    public boolean triggerAbility(TriggeredAbility source, Game game) {
        if (source != null && source.canChooseTarget(game, this.playerId)) {
            List options = this.getPlayableOptions((Ability)source, game);
            Object ability = options.isEmpty() ? source : (options.size() == 1 ? (Ability)options.get(0) : (Ability)options.get(RandomUtil.nextInt((int)options.size())));
            if (ability.isUsesStack()) {
                game.getStack().push(game, (StackObject)new StackAbility((Ability)ability, this.playerId));
                if (ability.activate(game, false)) {
                    game.fireEvent(new GameEvent(GameEvent.EventType.TRIGGERED_ABILITY, ability.getId(), (Ability)ability, ability.getControllerId()));
                    ++this.actionCount;
                    return true;
                }
            } else if (ability.activate(game, false)) {
                ability.resolve(game);
                ++this.actionCount;
                return true;
            }
        }
        return false;
    }

    @Override
    public void selectAttackers(Game game, UUID attackingPlayerId) {
        UUID defenderId = (UUID)game.getOpponents(this.playerId, true).iterator().next();
        List attackersList = super.getAvailableAttackers(defenderId, game);
        int powerElements = (int)Math.pow(2.0, attackersList.size());
        int value = RandomUtil.nextInt((int)powerElements);
        StringBuilder binary = new StringBuilder();
        binary.append(Integer.toBinaryString(value));
        while (binary.length() < attackersList.size()) {
            binary.insert(0, '0');
        }
        for (int i = 0; i < attackersList.size(); ++i) {
            if (binary.charAt(i) != '1') continue;
            this.setStoredBookmark(game.bookmarkState());
            if (game.getCombat().declareAttacker(((Permanent)attackersList.get(i)).getId(), defenderId, this.playerId, game)) continue;
            game.undo(this.playerId);
        }
        ++this.actionCount;
    }

    @Override
    public void selectBlockers(Ability source, Game game, UUID defendingPlayerId) {
        int numGroups = game.getCombat().getGroups().size();
        if (numGroups == 0) {
            return;
        }
        List blockers = this.getAvailableBlockers(game);
        for (Permanent blocker : blockers) {
            CombatGroup group;
            int check = RandomUtil.nextInt((int)(numGroups + 1));
            if (check >= numGroups || (group = (CombatGroup)game.getCombat().getGroups().get(check)).getAttackers().isEmpty()) continue;
            this.declareBlocker(this.getId(), blocker.getId(), (UUID)group.getAttackers().get(0), game);
        }
        ++this.actionCount;
    }

    public void abort() {
        this.abort = true;
    }

    private boolean chooseRandom(Target target, Ability source, Game game) {
        Set possibleTargets = target.possibleTargets(this.playerId, source, game);
        if (possibleTargets.isEmpty()) {
            return false;
        }
        if (possibleTargets.size() == 1) {
            target.add((UUID)possibleTargets.iterator().next(), game);
            return true;
        }
        Iterator it = possibleTargets.iterator();
        int targetNum = RandomUtil.nextInt((int)possibleTargets.size());
        UUID targetId = (UUID)it.next();
        for (int i = 0; i < targetNum; ++i) {
            targetId = (UUID)it.next();
        }
        target.add(targetId, game);
        return true;
    }

    protected boolean chooseRandomTarget(Target target, Ability source, Game game) {
        Set possibleTargets = target.possibleTargets(this.playerId, source, game);
        if (possibleTargets.isEmpty()) {
            return false;
        }
        if (!target.isRequired(source) && RandomUtil.nextInt((int)(possibleTargets.size() + 1)) == 0) {
            return false;
        }
        if (possibleTargets.size() == 1) {
            target.addTarget((UUID)possibleTargets.iterator().next(), source, game);
            return true;
        }
        Iterator it = possibleTargets.iterator();
        int targetNum = RandomUtil.nextInt((int)possibleTargets.size());
        UUID targetId = (UUID)it.next();
        for (int i = 0; i < targetNum; ++i) {
            targetId = (UUID)it.next();
        }
        target.addTarget(targetId, source, game);
        return true;
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game) {
        if (this.isHuman()) {
            return this.chooseRandom(target, source, game);
        }
        return super.choose(outcome, target, source, game);
    }

    public boolean choose(Outcome outcome, Target target, Ability source, Game game, Map<String, Serializable> options) {
        if (this.isHuman()) {
            return this.chooseRandom(target, source, game);
        }
        return super.choose(outcome, target, source, game, options);
    }

    public boolean choose(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (this.isHuman()) {
            if (cards.isEmpty()) {
                return false;
            }
            Set possibleTargets = target.possibleTargets(this.playerId, source, game, (Set)cards);
            if (possibleTargets.isEmpty()) {
                return false;
            }
            Iterator it = possibleTargets.iterator();
            int targetNum = RandomUtil.nextInt((int)possibleTargets.size());
            UUID targetId = (UUID)it.next();
            for (int i = 0; i < targetNum; ++i) {
                targetId = (UUID)it.next();
            }
            target.add(targetId, game);
            return true;
        }
        return super.choose(outcome, cards, target, source, game);
    }

    public boolean chooseTarget(Outcome outcome, Target target, Ability source, Game game) {
        return this.chooseRandomTarget(target, source, game);
    }

    public boolean chooseTarget(Outcome outcome, Cards cards, TargetCard target, Ability source, Game game) {
        if (cards.isEmpty()) {
            return !target.isRequired(source);
        }
        Card card = cards.getRandom(game);
        if (card != null) {
            target.addTarget(card.getId(), source, game);
            return true;
        }
        return false;
    }

    public boolean chooseTargetAmount(Outcome outcome, TargetAmount target, Ability source, Game game) {
        target.prepareAmount(source, game);
        if (target.getAmountRemaining() <= 0) {
            return false;
        }
        if (target.getMaxNumberOfTargets() == 0 && target.getMinNumberOfTargets() == 0) {
            return false;
        }
        Set possibleTargets = target.possibleTargets(this.playerId, source, game);
        if (possibleTargets.isEmpty()) {
            return !target.isRequired(source);
        }
        if (!target.isRequired(source) && RandomUtil.nextInt((int)(possibleTargets.size() + 1)) == 0) {
            return false;
        }
        if (possibleTargets.size() == 1) {
            target.addTarget((UUID)possibleTargets.iterator().next(), target.getAmountRemaining(), source, game);
            return true;
        }
        Iterator it = possibleTargets.iterator();
        int targetNum = RandomUtil.nextInt((int)possibleTargets.size());
        UUID targetId = (UUID)it.next();
        for (int i = 0; i < targetNum; ++i) {
            targetId = (UUID)it.next();
        }
        target.addTarget(targetId, RandomUtil.nextInt((int)target.getAmountRemaining()) + 1, source, game);
        return true;
    }

    public boolean chooseMulligan(Game game) {
        return RandomUtil.nextBoolean();
    }

    public boolean chooseUse(Outcome outcome, String message, Ability source, Game game) {
        if (this.isHuman()) {
            return RandomUtil.nextBoolean();
        }
        return super.chooseUse(outcome, message, source, game);
    }

    public boolean choosePile(Outcome outcome, String message, List<? extends Card> pile1, List<? extends Card> pile2, Game game) {
        if (this.isHuman()) {
            return RandomUtil.nextBoolean();
        }
        return super.choosePile(outcome, message, pile1, pile2, game);
    }

    public boolean choose(Outcome outcome, Choice choice, Game game) {
        if (this.isHuman()) {
            choice.setRandomChoice();
            return true;
        }
        return super.choose(outcome, choice, game);
    }

    public int chooseReplacementEffect(Map<String, String> effectsMap, Map<String, MageObject> objectsMap, Game game) {
        if (this.isHuman()) {
            return RandomUtil.nextInt((int)effectsMap.size());
        }
        return super.chooseReplacementEffect(effectsMap, objectsMap, game);
    }

    public TriggeredAbility chooseTriggeredAbility(List<TriggeredAbility> abilities, Game game) {
        if (this.isHuman()) {
            return abilities.get(RandomUtil.nextInt((int)abilities.size()));
        }
        return super.chooseTriggeredAbility(abilities, game);
    }

    public Mode chooseMode(Modes modes, Ability source, Game game) {
        if (this.isHuman()) {
            Iterator it = modes.getAvailableModes(source, game).iterator();
            Mode mode = (Mode)it.next();
            if (modes.size() == 1) {
                return mode;
            }
            int modeNum = RandomUtil.nextInt((int)modes.getAvailableModes(source, game).size());
            for (int i = 0; i < modeNum; ++i) {
                mode = (Mode)it.next();
            }
            return mode;
        }
        return super.chooseMode(modes, source, game);
    }

    public int getAmount(int min, int max, String message, Ability source, Game game) {
        if (this.isHuman()) {
            return RandomUtil.nextInt((int)(max - min + 1)) + min;
        }
        return super.getAmount(min, max, message, source, game);
    }
}

