/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.awt.Point;
import java.awt.Rectangle;
import mage.cards.MageCardSpace;

public class MageCardLocation {
    private final Rectangle componentRect;
    private final Rectangle cardRect;

    public MageCardLocation(Point componentLocation, MageCardSpace cardOuterSpace, Rectangle componentBounds) {
        this.componentRect = new Rectangle(componentLocation.x, componentLocation.y, componentBounds.width, componentBounds.height);
        this.cardRect = new Rectangle(this.componentRect.x + cardOuterSpace.left, this.componentRect.y + cardOuterSpace.top, this.componentRect.width - cardOuterSpace.getWidth(), this.componentRect.height - cardOuterSpace.getHeight());
    }

    public int getCardX() {
        return this.cardRect.x;
    }

    public int getCardY() {
        return this.cardRect.y;
    }

    public int getCardRelativeX() {
        return this.cardRect.x - this.componentRect.x;
    }

    public int getCardRelativeY() {
        return this.cardRect.y - this.componentRect.y;
    }

    public int getCardWidth() {
        return this.cardRect.width;
    }

    public int getCardHeight() {
        return this.cardRect.height;
    }

    public Point getCardPoint() {
        return new Point(this.cardRect.x, this.cardRect.y);
    }

    public int getComponentX() {
        return this.componentRect.x;
    }

    public int getComponentY() {
        return this.componentRect.y;
    }

    public int getComponentWidth() {
        return this.componentRect.width;
    }

    public int getComponentHeight() {
        return this.componentRect.height;
    }

    public Rectangle getCardBounds() {
        return new Rectangle(this.cardRect);
    }

    public Rectangle getComponentBounds() {
        return new Rectangle(this.componentRect);
    }
}

