/*
 * Decompiled with CFR 0.152.
 */
package mage.components.table;

import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mage.components.table.TableInfo;
import mage.components.table.TableModelWithTooltip;
import org.apache.log4j.Logger;
import org.ocpsoft.prettytime.PrettyTime;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.units.JustNow;

public class MageTable
extends JTable {
    private static final Logger logger = Logger.getLogger(MageTable.class);
    private TableInfo tableInfo;

    public MageTable() {
        this((TableInfo)null);
    }

    public MageTable(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Point p = e.getPoint();
        int viewRow = this.rowAtPoint(p);
        int viewCol = this.columnAtPoint(p);
        int modelRow = MageTable.getModelRowFromView(this, viewRow);
        int modelCol = this.convertColumnIndexToModel(viewCol);
        String tip = null;
        if (modelRow != -1 && modelCol != -1) {
            TableModel model = this.getModel();
            tip = model instanceof TableModelWithTooltip ? ((TableModelWithTooltip)((Object)model)).getTooltipAt(modelRow, modelCol) : model.getValueAt(modelRow, modelCol).toString();
        }
        return MageTable.textToHtmlWithSize(tip, this.getFont());
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip;
                Point p = e.getPoint();
                int colIndex = this.columnModel.getColumnIndexAtX(p.x);
                if (colIndex < 0) {
                    return "";
                }
                TableColumn col = this.columnModel.getColumn(colIndex);
                int realIndex = col.getModelIndex();
                if (MageTable.this.tableInfo != null) {
                    tip = MageTable.this.tableInfo.getColumnByIndex(realIndex).getHeaderHint();
                    if (tip == null) {
                        tip = MageTable.this.tableInfo.getColumnByIndex(realIndex).getHeaderName();
                    }
                } else {
                    tip = col.getHeaderValue().toString();
                }
                return MageTable.textToHtmlWithSize(tip, MageTable.this.getFont());
            }
        };
    }

    public static int getSelectedModelRow(JTable table) {
        return MageTable.getModelRowFromView(table, table.getSelectedRow());
    }

    public static int getModelRowFromView(JTable table, int viewRow) {
        if (viewRow != -1 && viewRow < table.getModel().getRowCount()) {
            return table.convertRowIndexToModel(viewRow);
        }
        return -1;
    }

    public static int getViewRowFromModel(JTable table, int modelRow) {
        if (modelRow != -1 && modelRow < table.getModel().getRowCount()) {
            return table.convertRowIndexToView(modelRow);
        }
        return -1;
    }

    public static String textToHtmlWithSize(String text, Font font) {
        if (text != null && !text.toLowerCase(Locale.ENGLISH).startsWith("<html>")) {
            return "<html><p style=\"font-size: " + font.getSize() + "pt;\">" + text + "</p>";
        }
        return text;
    }

    public static void fixTimeFormatter(PrettyTime timeFormatter) {
        TimeFormat timeFormat = timeFormatter.removeUnit(JustNow.class);
        JustNow newJustNow = new JustNow();
        newJustNow.setMaxQuantity(30000L);
        timeFormatter.registerUnit((TimeUnit)newJustNow, timeFormat);
    }
}

