/*
 * Decompiled with CFR 0.152.
 */
package mage.interfaces.callback;

import java.io.Serializable;
import java.util.UUID;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.remote.traffic.ZippedObject;
import mage.util.ThreadUtils;
import mage.utils.CompressUtil;

public class ClientCallback
implements Serializable {
    private static final String SIMULATE_BAD_CONNECTION_PROP = "xmage.badConnection";
    public static final boolean SIMULATE_BAD_CONNECTION = System.getProperty("xmage.badConnection") != null;
    private UUID objectId;
    private Object data;
    private ClientCallbackMethod method;
    private int messageId;

    public ClientCallback(ClientCallbackMethod method, UUID objectId) {
        this(method, objectId, null);
    }

    public ClientCallback(ClientCallbackMethod method, UUID objectId, Object data) {
        this(method, objectId, data, true);
    }

    public ClientCallback(ClientCallbackMethod method, UUID objectId, Object data, boolean useCompress) {
        this.method = method;
        this.objectId = objectId;
        this.setData(data, useCompress);
    }

    private void simulateBadConnection() {
        if (SIMULATE_BAD_CONNECTION) {
            ThreadUtils.sleep((int)100);
        }
    }

    public void clear() {
        this.method = null;
        this.data = null;
    }

    public UUID getObjectId() {
        return this.objectId;
    }

    public void setObjectId(UUID objectId) {
        this.objectId = objectId;
    }

    public Object getData() {
        if (this.data instanceof ZippedObject) {
            throw new IllegalStateException("Client data must be decompressed first");
        }
        return this.data;
    }

    public void setData(Object data, boolean useCompress) {
        if (!useCompress || data == null || data instanceof ZippedObject) {
            this.data = data;
        } else {
            this.data = CompressUtil.compress(data);
            this.simulateBadConnection();
        }
    }

    public void decompressData() {
        if (this.data instanceof ZippedObject) {
            this.data = CompressUtil.decompress(this.data);
            this.simulateBadConnection();
        }
    }

    public ClientCallbackMethod getMethod() {
        return this.method;
    }

    public void setMethod(ClientCallbackMethod method) {
        this.method = method;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public String getInfo() {
        return String.format("message %d - %s - %s", new Object[]{this.getMessageId(), this.getMethod().getType(), this.getMethod()});
    }
}

