/*
 * Decompiled with CFR 0.152.
 */
package mage.remote.traffic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import mage.remote.traffic.ZippedObject;

public class ZippedObjectImpl<T>
implements ZippedObject<T>,
Serializable {
    private byte[] data;
    private static final long serialVersionUID = 1L;

    public ZippedObjectImpl(T object) {
        this.zip(object);
    }

    @Override
    public void zip(T object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(bos);
            ObjectOutputStream oos = new ObjectOutputStream(gz);
            oos.writeObject(object);
            oos.close();
            this.data = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public T unzip() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            GZIPInputStream gz = new GZIPInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(gz);
            Object o = ois.readObject();
            return (T)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

