/*
 * Decompiled with CFR 0.152.
 */
package mage.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mage.Mana;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.constants.ColoredManaSymbol;
import mage.constants.SubType;
import mage.interfaces.rate.RateCallback;
import mage.util.RandomUtil;

public final class DeckBuilder {
    private static final int[] DECK_COUNT40 = new int[]{3, 6, 6, 4, 3, 2};
    private static final int[] DECK_COUNT60 = new int[]{4, 9, 9, 5, 5, 3};
    private static final int[] DECK_COST = new int[]{1, 2, 3, 4, 6, 10};
    private static final int MIN_CARD_SCORE = 25;
    private static final int MIN_SOURCE = 3;
    private static Deck deck;
    private static int[] deckCount;
    private static int deckSize;
    private static int deckSpells;
    private static int deckLands;

    private DeckBuilder() {
    }

    public static synchronized Deck buildDeck(List<Card> spellCardPool, List<ColoredManaSymbol> allowedColors, List<String> setsToUse, List<Card> landCardPool, int deckCardSize, RateCallback callback) {
        deckSize = deckCardSize;
        deck = new Deck();
        ArrayList<MageScoredCard> remainingCards = new ArrayList<MageScoredCard>();
        HashSet<String> names = new HashSet<String>();
        for (Card card : spellCardPool) {
            if (names.contains(card.getName())) continue;
            remainingCards.add(new MageScoredCard(card, allowedColors, callback));
            names.add(card.getName());
        }
        int min = 0;
        if (deckSize == 40) {
            deckCount = DECK_COUNT40;
            deckSpells = 23;
            deckLands = 17;
        } else {
            deckCount = DECK_COUNT60;
            deckSpells = 35;
            deckLands = 25;
        }
        for (int index = 0; index < deckCount.length; ++index) {
            int max = DECK_COST[index];
            DeckBuilder.addCardsToDeck(remainingCards, min, max, deckCount[index]);
            min = max + 1;
        }
        DeckBuilder.addCardsToDeck(remainingCards, 0, 4, deckSpells - deck.getMaindeckCards().size());
        DeckBuilder.addCardsToDeck(remainingCards, 5, 10, deckSpells - deck.getMaindeckCards().size());
        DeckBuilder.addLandsToDeck(allowedColors, setsToUse, landCardPool, callback);
        Deck returnedDeck = deck;
        deck = null;
        return returnedDeck;
    }

    private static void addCardsToDeck(Collection<MageScoredCard> remainingCards, int minCost, int maxCost, int count) {
        for (int c = count; c > 0; --c) {
            MageScoredCard bestCard = null;
            int bestScore = -1;
            for (MageScoredCard draftedCard : remainingCards) {
                int score = draftedCard.getScore();
                int cost = draftedCard.getConvertedCost();
                if (score <= bestScore || cost < minCost || cost > maxCost) continue;
                bestScore = score;
                bestCard = draftedCard;
            }
            if (bestCard == null || bestScore < 25) break;
            deck.getCards().add(bestCard.card);
            remainingCards.remove(bestCard);
        }
    }

    private static void addLandsToDeck(List<ColoredManaSymbol> allowedColors, List<String> setsToUse, List<Card> landCardPool, RateCallback callback) {
        HashMap<String, Integer> colorCount = new HashMap<String, Integer>();
        for (Object card : deck.getCards()) {
            for (String symbol : card.getManaCostSymbols()) {
                int count = 0;
                if (!DeckBuilder.isColoredMana(symbol = symbol.replace("{", "").replace("}", ""))) continue;
                for (ColoredManaSymbol allowed : allowedColors) {
                    if (!symbol.contains(allowed.toString())) continue;
                    ++count;
                }
                if (count <= 0) continue;
                Integer typeCount = colorCount.getOrDefault(symbol, 0);
                typeCount = typeCount + 1;
                colorCount.put(symbol, typeCount);
            }
        }
        HashMap<String, Integer> colorSource = new HashMap<String, Integer>();
        for (ColoredManaSymbol color : ColoredManaSymbol.values()) {
            colorSource.put(color.toString(), 0);
        }
        if (landCardPool != null) {
            for (Card landCard : landCardPool) {
                deck.getCards().add(landCard);
                for (Mana mana : landCard.getMana()) {
                    for (ColoredManaSymbol color : allowedColors) {
                        int amount = mana.getColor(color);
                        if (amount <= 0) continue;
                        Integer count = (Integer)colorSource.get(color.toString());
                        count = count + amount;
                        colorSource.put(color.toString(), count);
                    }
                }
            }
        }
        while (deck.getMaindeckCards().size() < deckSize) {
            ColoredManaSymbol bestColor = null;
            if (allowedColors != null && !allowedColors.isEmpty()) {
                bestColor = allowedColors.get(RandomUtil.nextInt((int)allowedColors.size()));
            }
            int lowestRatio = Integer.MAX_VALUE;
            for (ColoredManaSymbol color : ColoredManaSymbol.values()) {
                int source;
                int ratio;
                Integer count = (Integer)colorCount.get(color.toString());
                if (count == null || count <= 0 || (ratio = (source = ((Integer)colorSource.get(color.toString())).intValue()) < 3 ? source - count : source * 100 / count) >= lowestRatio) continue;
                lowestRatio = ratio;
                bestColor = color;
            }
            Card landCard = callback.getBestBasicLand(bestColor, setsToUse);
            Integer count = (Integer)colorSource.get(bestColor.toString());
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            colorSource.put(bestColor.toString(), count);
            deck.getCards().add(landCard);
        }
    }

    protected static boolean isColoredMana(String symbol) {
        return symbol.equals("W") || symbol.equals("G") || symbol.equals("U") || symbol.equals("B") || symbol.equals("R") || symbol.contains("/");
    }

    private static class MageScoredCard {
        private Card card;
        private final int score;
        private static final int[] SINGLE_PENALTY = new int[]{0, 1, 1, 3, 6, 9};

        public MageScoredCard(Card card, List<ColoredManaSymbol> allowedColors, RateCallback cardRater) {
            this.card = card;
            int type = card.isCreature() ? 10 : (card.hasSubtype(SubType.EQUIPMENT, null) ? 8 : (card.hasSubtype(SubType.AURA, null) ? 5 : (card.isInstant() ? 7 : 6)));
            this.score = 3 * cardRater.rateCard(card) + type + this.getManaCostScore(card, allowedColors);
        }

        private int getManaCostScore(Card card, List<ColoredManaSymbol> allowedColors) {
            int converted = card.getManaValue();
            HashMap<String, Integer> singleCount = new HashMap<String, Integer>();
            int maxSingleCount = 0;
            int multicolor = 0;
            HashSet<String> colors = new HashSet<String>();
            for (String symbol : card.getManaCostSymbols()) {
                int count = 0;
                if (!DeckBuilder.isColoredMana(symbol = symbol.replace("{", "").replace("}", ""))) continue;
                for (ColoredManaSymbol allowed : allowedColors) {
                    if (!symbol.contains(allowed.toString())) continue;
                    ++count;
                }
                if (count == 0) {
                    return -30;
                }
                if (!colors.contains(symbol)) {
                    ++multicolor;
                    colors.add(symbol);
                }
                Integer typeCount = singleCount.getOrDefault(symbol, 0);
                typeCount = typeCount + 1;
                singleCount.put(symbol, typeCount);
                maxSingleCount = Math.max(maxSingleCount, typeCount);
            }
            int multicolorBonus = multicolor > 1 ? 30 : 0;
            maxSingleCount = Math.min(maxSingleCount, SINGLE_PENALTY.length - 1);
            return 2 * converted + 3 * (10 - SINGLE_PENALTY[maxSingleCount]) + multicolorBonus;
        }

        public int getScore() {
            return this.score;
        }

        public int getConvertedCost() {
            return this.card.getManaValue();
        }

        public Card getCard() {
            return this.card;
        }
    }
}

