/*
 * Decompiled with CFR 0.152.
 */
package mage.utils;

import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.cards.Card;
import mage.cards.decks.importer.CardLookup;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.GameCommanderImpl;
import mage.game.command.CommandObject;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;
import mage.util.MultiAmountMessage;
import mage.util.RandomUtil;
import mage.utils.testers.TestableDialogsRunner;
import org.apache.log4j.Logger;

public final class SystemUtil {
    public static final DateFormat dateFormat = new SimpleDateFormat("yy-M-dd HH:mm:ss");
    private static final String INIT_FILE_PATH = "config" + File.separator + "init.txt";
    private static final Logger logger = Logger.getLogger(SystemUtil.class);
    private static final String COMMAND_REF_PREFIX = "@";
    private static final String COMMAND_CARDS_ADD_TO_HAND = "@card add to hand";
    private static final String COMMAND_LANDS_ADD_TO_BATTLEFIELD = "@lands add";
    private static final String COMMAND_UNDER_CONTROL_TAKE = "@under control take";
    private static final String COMMAND_UNDER_CONTROL_GIVE = "@under control give";
    private static final String COMMAND_SHOW_TEST_DIALOGS = "@show dialog";
    private static final String COMMAND_MANA_ADD = "@mana add";
    private static final String COMMAND_RUN_CUSTOM_CODE = "@run custom code";
    private static final String COMMAND_SHOW_OPPONENT_HAND = "@show opponent hand";
    private static final String COMMAND_SHOW_OPPONENT_LIBRARY = "@show opponent library";
    private static final String COMMAND_SHOW_MY_HAND = "@show my hand";
    private static final String COMMAND_SHOW_MY_LIBRARY = "@show my library";
    private static final Map<String, String> supportedCommands = new HashMap<String, String>();
    private static final TestableDialogsRunner testableDialogsRunner = new TestableDialogsRunner();
    private static final Pattern patternGroup;
    private static final Pattern patternCommand;
    private static final Pattern patternCardInfo;
    private static final String PARAM_COLOR_COST = "color cost";
    private static final String PARAM_COLOR_COMMANDER = "color commander";
    private static final String PARAM_PT = "pt";
    private static final String PARAM_ABILITIES_COUNT = "abilities count";
    private static final String PARAM_ABILITIES_LIST = "abilities list";

    private SystemUtil() {
    }

    private static String getCardsListForSpecialInform(Game game, Set<UUID> cardsList, List<String> commandParams) {
        return SystemUtil.getCardsListForSpecialInform(game, cardsList.stream().collect(Collectors.toList()), commandParams);
    }

    private static String getCardsListForSpecialInform(Game game, List<UUID> cardsList, List<String> commandParams) {
        ArrayList<String> res = new ArrayList<String>();
        for (UUID cardID : cardsList) {
            Card card = game.getCard(cardID);
            if (card == null) continue;
            String cardInfo = card.getName() + " - " + card.getExpansionSetCode();
            ArrayList<String> resInfo = new ArrayList<String>();
            Iterator<String> iterator = commandParams.iterator();
            block15: while (iterator.hasNext()) {
                String param;
                switch (param = iterator.next()) {
                    case "color cost": {
                        resInfo.add(card.getColor(game).toString());
                        continue block15;
                    }
                    case "color commander": {
                        resInfo.add(card.getColorIdentity().toString());
                        continue block15;
                    }
                    case "pt": {
                        resInfo.add(card.getPower() + " / " + card.getToughness());
                        continue block15;
                    }
                    case "abilities count": {
                        resInfo.add(String.valueOf(card.getAbilities(game).size()));
                        continue block15;
                    }
                    case "abilities list": {
                        resInfo.add(card.getAbilities(game).stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")));
                        continue block15;
                    }
                }
                logger.warn((Object)("Unknown param for cards list: " + param));
            }
            if (!resInfo.isEmpty()) {
                cardInfo = cardInfo + ": " + resInfo.stream().collect(Collectors.joining("; "));
            }
            res.add(cardInfo);
        }
        return res.stream().sorted().collect(Collectors.joining("\n"));
    }

    public static CardCommandData parseCardCommand(String commandLine) {
        CardCommandData com = new CardCommandData();
        com.source = commandLine.trim();
        com.OK = false;
        com.Error = "unknown error";
        Matcher matchCommand = patternCommand.matcher(com.source);
        if (!matchCommand.matches()) {
            com.Error = "Unknown command format";
            return com;
        }
        com.zone = matchCommand.group(1);
        com.player = matchCommand.group(2);
        try {
            com.Amount = Integer.parseInt(matchCommand.group(4));
        }
        catch (Throwable e) {
            com.Error = "Can't parse amount value [" + matchCommand.group(4) + "]";
            return com;
        }
        List<String> cardInfo = SystemUtil.parseSetAndCardNameCommand(matchCommand.group(3));
        com.cardSet = cardInfo.get(0);
        com.cardName = cardInfo.get(1);
        if (com.cardName.isEmpty()) {
            com.Error = "Card name is empty";
            return com;
        }
        if (com.Amount <= 0) {
            com.Error = "Amount [" + com.Amount + "] must be greater than 0";
            return com;
        }
        com.Error = "";
        com.OK = true;
        return com;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeCheatCommands(Game game, String commandsFilePath, Player feedbackPlayer) {
        SimpleStaticAbility fakeSourceAbilityTemplate = new SimpleStaticAbility(Zone.OUTSIDE, (Effect)new InfoEffect("fake ability"));
        fakeSourceAbilityTemplate.setControllerId(feedbackPlayer.getId());
        Card fakeSourceCard = feedbackPlayer.getLibrary().getFromTop(game);
        if (fakeSourceCard != null) {
            fakeSourceAbilityTemplate.setSourceId(fakeSourceCard.getId());
        }
        ArrayList<String> errorsList = new ArrayList<String>();
        try {
            String mes;
            File f;
            String fileName = commandsFilePath;
            if (fileName == null) {
                fileName = INIT_FILE_PATH;
            }
            if (!(f = new File(fileName)).exists()) {
                String mes2 = String.format("Couldn't find init file: %s", f.getAbsolutePath());
                logger.warn((Object)mes2);
                errorsList.add(mes2);
                SystemUtil.sendCheatCommandsFeedback(game, feedbackPlayer, errorsList);
                return;
            }
            logger.info((Object)"Parsing init file... ");
            ArrayList<CommandGroup> groups = new ArrayList<CommandGroup>();
            ArrayList<String> initLines = new ArrayList<String>();
            Scanner scanner = new Scanner(f);
            Object object = null;
            try {
                while (scanner.hasNextLine()) {
                    initLines.add(scanner.nextLine().trim());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            initLines.add(0, String.format("[%s]", COMMAND_LANDS_ADD_TO_BATTLEFIELD));
            initLines.add(1, String.format("[%s]", COMMAND_CARDS_ADD_TO_HAND));
            initLines.add(2, String.format("[%s]", COMMAND_SHOW_TEST_DIALOGS));
            initLines.add(3, String.format("[%s]", COMMAND_UNDER_CONTROL_TAKE));
            initLines.add(4, String.format("[%s]", COMMAND_UNDER_CONTROL_GIVE));
            CommandGroup currentGroup = null;
            for (String line : initLines) {
                if (line.isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
                Matcher matchGroup = patternGroup.matcher(line);
                if (matchGroup.matches()) {
                    String groupName = matchGroup.group(1);
                    if (groupName.startsWith(COMMAND_REF_PREFIX)) {
                        if (supportedCommands.containsKey(groupName)) {
                            currentGroup = new CommandGroup(groupName, true);
                            groups.add(currentGroup);
                            continue;
                        }
                        String mes3 = String.format("Special group is not supported: %s", groupName);
                        errorsList.add(mes3);
                        logger.warn((Object)mes3);
                        continue;
                    }
                    currentGroup = new CommandGroup(groupName);
                    groups.add(currentGroup);
                    continue;
                }
                if (currentGroup == null) {
                    currentGroup = new CommandGroup("default group");
                    groups.add(currentGroup);
                }
                currentGroup.commands.add(line);
            }
            CommandGroup runGroup = null;
            if (groups.size() == 1) {
                runGroup = (CommandGroup)groups.get(0);
            } else if (groups.size() > 1) {
                String need;
                logger.info((Object)("Found " + groups.size() + " groups. Need to select."));
                ChoiceImpl groupChoice = new ChoiceImpl(false);
                groupChoice.setMessage("Choose commands group to run");
                for (int i = 0; i < groups.size(); ++i) {
                    groupChoice.withItem(Integer.toString(i + 1), ((CommandGroup)groups.get(i)).getPrintNameWithStats(), Integer.valueOf(i), ChoiceHintType.TEXT, String.join((CharSequence)"<br>", ((CommandGroup)groups.get((int)i)).commands));
                }
                if (feedbackPlayer.choose(Outcome.Benefit, (Choice)groupChoice, game) && (need = groupChoice.getChoiceKey()) != null) {
                    runGroup = (CommandGroup)groups.get(Integer.parseInt(need) - 1);
                }
            }
            if (runGroup == null) {
                logger.info((Object)"Command file was empty or canceled");
                return;
            }
            logger.info((Object)String.format("Selected group [%s] with %d commands", runGroup.name, runGroup.commands.size()));
            if (runGroup.isSpecialCommand) {
                Player opponent = game.getPlayer((UUID)game.getOpponents(feedbackPlayer.getId(), true).stream().findFirst().orElse(null));
                switch (runGroup.name) {
                    case "@show opponent hand": {
                        if (opponent == null) return;
                        String info = SystemUtil.getCardsListForSpecialInform(game, (Set<UUID>)opponent.getHand(), runGroup.commands);
                        game.informPlayer(feedbackPlayer, info);
                        return;
                    }
                    case "@show opponent library": {
                        if (opponent == null) return;
                        String info = SystemUtil.getCardsListForSpecialInform(game, opponent.getLibrary().getCardList(), runGroup.commands);
                        game.informPlayer(feedbackPlayer, info);
                        return;
                    }
                    case "@show my hand": {
                        String info = SystemUtil.getCardsListForSpecialInform(game, (Set<UUID>)feedbackPlayer.getHand(), runGroup.commands);
                        game.informPlayer(feedbackPlayer, info);
                        return;
                    }
                    case "@show my library": {
                        String info = SystemUtil.getCardsListForSpecialInform(game, feedbackPlayer.getLibrary().getCardList(), runGroup.commands);
                        game.informPlayer(feedbackPlayer, info);
                        return;
                    }
                    case "@card add to hand": {
                        ChoiceImpl cardChoice = new ChoiceImpl(false, ChoiceHintType.CARD);
                        cardChoice.setChoices(CardRepository.instance.getNames());
                        cardChoice.setMessage("Choose card name to put in hand");
                        if (!feedbackPlayer.choose(Outcome.Detriment, (Choice)cardChoice, game)) return;
                        if (cardChoice.getChoice() == null) {
                            return;
                        }
                        String cardName = cardChoice.getChoice();
                        int cardAmount = feedbackPlayer.getAmount(1, 100, "How many [" + cardName + "] to add?", null, game);
                        if (cardAmount == 0) {
                            return;
                        }
                        Set<Card> newCards = SystemUtil.addNewCardsToGame(game, cardName, null, cardAmount, feedbackPlayer);
                        if (newCards == null) {
                            String mes4 = String.format("Can't add cards to hand: %s", cardName);
                            errorsList.add(mes4);
                            logger.warn((Object)mes4);
                            return;
                        }
                        for (Card card2 : newCards) {
                            Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                            fakeSourceAbility.setSourceId(card2.getId());
                            SystemUtil.putCardToZone(fakeSourceAbility, game, feedbackPlayer, card2, Zone.HAND);
                        }
                        return;
                    }
                    case "@lands add": {
                        ArrayList<MultiAmountMessage> lands = new ArrayList<MultiAmountMessage>();
                        String spaceSymbol = "&nbsp;";
                        lands.add(new MultiAmountMessage("{W}" + spaceSymbol + "Plains", 0, 10, 5));
                        lands.add(new MultiAmountMessage("{U}" + spaceSymbol + "Island", 0, 10, 5));
                        lands.add(new MultiAmountMessage("{B}" + spaceSymbol + "Swamp", 0, 10, 5));
                        lands.add(new MultiAmountMessage("{R}" + spaceSymbol + "Mountain", 0, 10, 5));
                        lands.add(new MultiAmountMessage("{G}" + spaceSymbol + "Forest", 0, 10, 5));
                        lands.add(new MultiAmountMessage("{C}" + spaceSymbol + "Ash Barrens", 0, 10, 0));
                        List landsAmount = feedbackPlayer.getMultiAmountWithIndividualConstraints(Outcome.Neutral, lands, 0, 100, MultiAmountType.CHEAT_LANDS, game);
                        if (landsAmount == null) {
                            return;
                        }
                        LinkedHashSet<Card> newCards = new LinkedHashSet<Card>();
                        for (int i = 0; i < landsAmount.size(); ++i) {
                            int cardAmount = (Integer)landsAmount.get(i);
                            String cardName = ((MultiAmountMessage)lands.get((int)i)).message.substring("{W}".length()).replace(spaceSymbol, " ").trim();
                            if (cardAmount <= 0) continue;
                            Set<Card> addedCards = SystemUtil.addNewCardsToGame(game, cardName, null, cardAmount, feedbackPlayer);
                            if (addedCards != null) {
                                newCards.addAll(addedCards);
                                continue;
                            }
                            errorsList.add("Can't add land card to game: " + cardName);
                        }
                        for (Card card3 : newCards) {
                            Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                            fakeSourceAbility.setSourceId(card3.getId());
                            SystemUtil.putCardToZone(fakeSourceAbility, game, feedbackPlayer, card3, Zone.BATTLEFIELD);
                        }
                        return;
                    }
                    case "@under control take": {
                        Target target = new TargetOpponent().withNotTarget(true).withChooseHint("to take under your control");
                        Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                        if (!feedbackPlayer.chooseTarget(Outcome.GainControl, target, fakeSourceAbility, game)) return;
                        Player targetPlayer = game.getPlayer(target.getFirstTarget());
                        if (!targetPlayer.getId().equals(feedbackPlayer.getId())) {
                            CardUtil.takeControlUnderPlayerStart((Game)game, (Ability)fakeSourceAbility, (Player)feedbackPlayer, (Player)targetPlayer, (boolean)false);
                            targetPlayer.resetPassed();
                        }
                        game.firePriorityEvent(feedbackPlayer.getId());
                        return;
                    }
                    case "@under control give": {
                        Target target = new TargetPlayer().withNotTarget(true).withChooseHint("to give control of your player");
                        Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                        if (!feedbackPlayer.chooseTarget(Outcome.GainControl, target, fakeSourceAbility, game)) return;
                        Player targetPlayer = game.getPlayer(target.getFirstTarget());
                        if (targetPlayer != null) {
                            if (!targetPlayer.getId().equals(feedbackPlayer.getId())) {
                                CardUtil.takeControlUnderPlayerStart((Game)game, (Ability)fakeSourceAbility, (Player)targetPlayer, (Player)feedbackPlayer, (boolean)false);
                            } else {
                                CardUtil.takeControlUnderPlayerEnd((Game)game, (Ability)fakeSourceAbility, (Player)feedbackPlayer, (Player)targetPlayer);
                            }
                        }
                        game.firePriorityEvent(feedbackPlayer.getId());
                        return;
                    }
                    case "@show dialog": {
                        testableDialogsRunner.selectAndShowTestableDialog(feedbackPlayer, fakeSourceAbilityTemplate.copy(), game, opponent);
                        return;
                    }
                    default: {
                        String mes5 = String.format("Unknown system command: %s", runGroup.name);
                        errorsList.add(mes5);
                        logger.error((Object)mes5);
                        return;
                    }
                }
            }
            HashMap<String, CommandGroup> otherGroupRefs = new HashMap<String, CommandGroup>();
            for (CommandGroup group : groups) {
                if (group == runGroup) continue;
                otherGroupRefs.putIfAbsent(COMMAND_REF_PREFIX + group.name, group);
            }
            for (int i = runGroup.commands.size() - 1; i >= 0; --i) {
                String line = runGroup.commands.get(i);
                if (!line.startsWith(COMMAND_REF_PREFIX)) continue;
                CommandGroup other = otherGroupRefs.getOrDefault(line, null);
                if (other != null && !other.isSpecialCommand) {
                    logger.info((Object)String.format("Replace ref group [%s] by %d child commands", line, other.commands.size()));
                    runGroup.commands.remove(i);
                    runGroup.commands.addAll(i, other.commands);
                    continue;
                }
                mes = String.format("Can't find ref group: %s", line);
                errorsList.add(mes);
                logger.error((Object)mes);
            }
            for (String line : runGroup.commands) {
                Zone gameZone;
                Object mes6;
                Constructor<?> cons;
                Class<?> c;
                CardCommandData command = SystemUtil.parseCardCommand(line);
                if (!command.OK.booleanValue()) {
                    mes = String.format("%s: %s", command.Error, line);
                    errorsList.add(mes);
                    logger.warn((Object)mes);
                    continue;
                }
                Optional<Player> playerOptional = SystemUtil.findPlayer(game, command.player);
                if (!playerOptional.isPresent()) {
                    String mes7 = String.format("Unknown player: %s", line);
                    errorsList.add(mes7);
                    logger.warn((Object)mes7);
                    continue;
                }
                Player player = playerOptional.get();
                if ("token".equalsIgnoreCase(command.zone)) {
                    c = Class.forName("mage.game.permanent.token." + command.cardName);
                    cons = c.getConstructor(new Class[0]);
                    Object obj = cons.newInstance(new Object[0]);
                    if (obj instanceof Token) {
                        Token token = (Token)obj;
                        Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                        fakeSourceAbility.setSourceId(token.getId());
                        token.putOntoBattlefield(command.Amount.intValue(), game, fakeSourceAbility, player.getId(), false, false);
                        continue;
                    }
                } else if ("emblem".equalsIgnoreCase(command.zone)) {
                    c = Class.forName("mage.game.command.emblems." + command.cardName);
                    cons = c.getConstructor(new Class[0]);
                    Object emblem = cons.newInstance(new Object[0]);
                    if (emblem instanceof Emblem) {
                        ((Emblem)emblem).setControllerId(player.getId());
                        game.addEmblem((Emblem)emblem, null, player.getId());
                        continue;
                    }
                } else if ("plane".equalsIgnoreCase(command.zone)) {
                    if (SystemUtil.putPlaneToGame(game, player, command.cardName)) {
                        continue;
                    }
                } else {
                    if ("loyalty".equalsIgnoreCase(command.zone)) {
                        for (Permanent perm : game.getBattlefield().getAllActivePermanents(player.getId())) {
                            if (!perm.getName().equals(command.cardName) || !perm.getCardType(game).contains(CardType.PLANESWALKER)) continue;
                            Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                            fakeSourceAbility.setSourceId(perm.getId());
                            perm.addCounters(CounterType.LOYALTY.createInstance(command.Amount.intValue()), fakeSourceAbility.getControllerId(), fakeSourceAbility, game);
                        }
                        continue;
                    }
                    if ("stack".equalsIgnoreCase(command.zone)) {
                        Set<Card> newCards = SystemUtil.addNewCardsToGame(game, command.cardName, command.cardSet, command.Amount, player);
                        if (newCards == null) {
                            mes6 = String.format("Unknown card for stack command [%s]: %s", command.cardName, line);
                            errorsList.add((String)mes6);
                            logger.warn(mes6);
                            continue;
                        }
                        for (Card card4 : newCards) {
                            Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                            fakeSourceAbility.setSourceId(card4.getId());
                            SystemUtil.putCardToZone(fakeSourceAbility, game, player, card4, Zone.STACK);
                        }
                        continue;
                    }
                }
                if ("hand".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.HAND;
                } else if ("battlefield".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.BATTLEFIELD;
                } else if ("graveyard".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.GRAVEYARD;
                } else if ("library".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.LIBRARY;
                } else if ("token".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.BATTLEFIELD;
                } else if ("exiled".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.EXILED;
                } else if ("outside".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.OUTSIDE;
                } else if ("emblem".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.COMMAND;
                } else if ("plane".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.COMMAND;
                } else if ("commander".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.COMMAND;
                } else if ("sideboard".equalsIgnoreCase(command.zone)) {
                    gameZone = Zone.OUTSIDE;
                } else {
                    mes6 = String.format("Unknown zone [%s]: %s", command.zone, line);
                    errorsList.add((String)mes6);
                    logger.warn(mes6);
                    continue;
                }
                List cards = command.cardSet.isEmpty() ? CardRepository.instance.findCards(command.cardName) : CardRepository.instance.findCards(new CardCriteria().setCodes(new String[]{command.cardSet}).name(command.cardName));
                if (cards.isEmpty()) {
                    String mes8 = String.format("Unknown card [%s%s]: %s", command.cardSet.isEmpty() ? "" : command.cardSet + "-", command.cardName, line);
                    errorsList.add(mes8);
                    logger.warn((Object)mes8);
                    continue;
                }
                HashSet<Card> cardsToLoad = new HashSet<Card>();
                for (int i = 0; i < command.Amount; ++i) {
                    Card card5;
                    CardInfo cardInfo = (CardInfo)cards.get(RandomUtil.nextInt((int)cards.size()));
                    Card card6 = card5 = cardInfo != null ? cardInfo.createCard() : null;
                    if (card5 == null) continue;
                    cardsToLoad.add(card5);
                }
                game.loadCards(cardsToLoad, player.getId());
                if ("commander".equalsIgnoreCase(command.zone) && cardsToLoad.size() > 0) {
                    if (game instanceof GameCommanderImpl) {
                        GameCommanderImpl gameCommander = (GameCommanderImpl)game;
                        cardsToLoad.forEach(card -> gameCommander.addCommander(card, player));
                        cardsToLoad.forEach(card -> gameCommander.initCommander(card, player));
                        continue;
                    }
                    String mes9 = String.format("Commander card can be used in commander game only: %s", command.cardName);
                    errorsList.add(mes9);
                    logger.error((Object)mes9);
                    continue;
                }
                if ("sideboard".equalsIgnoreCase(command.zone) && cardsToLoad.size() > 0) {
                    for (Card card7 : cardsToLoad) {
                        player.getSideboard().add(card7);
                    }
                    continue;
                }
                for (Card card7 : cardsToLoad) {
                    Ability fakeSourceAbility = fakeSourceAbilityTemplate.copy();
                    fakeSourceAbility.setSourceId(card7.getId());
                    SystemUtil.putCardToZone(fakeSourceAbility, game, player, card7, gameZone);
                }
            }
            return;
        }
        catch (Exception e) {
            String mes = String.format("Catch critical error on cheating: %s", e.getMessage());
            errorsList.add(mes);
            logger.error((Object)mes, (Throwable)e);
            return;
        }
        finally {
            SystemUtil.sendCheatCommandsFeedback(game, feedbackPlayer, errorsList);
        }
    }

    private static void sendCheatCommandsFeedback(Game game, Player feedbackPlayer, List<String> errorsList) {
        if (errorsList.size() > 0) {
            String mes = String.format("Player %s tried to apply cheat commands and catch %d errors:\n\n", feedbackPlayer.getName(), errorsList.size());
            mes = mes + String.join((CharSequence)"\n", errorsList);
            mes = mes + "\n";
            game.fireErrorEvent("Cheat command errors, see server logs for details", (Exception)new IllegalArgumentException(mes));
        }
        game.informPlayers(String.format("%s: tried to apply cheat commands", feedbackPlayer.getLogName()));
    }

    private static Set<Card> addNewCardsToGame(Game game, String cardName, String setCode, int amount, Player owner) {
        CardInfo cardInfo = CardLookup.instance.lookupCardInfo(cardName, setCode, null);
        if (cardInfo == null || amount <= 0) {
            return null;
        }
        LinkedHashSet<Card> cardsToLoad = new LinkedHashSet<Card>();
        for (int i = 0; i < amount; ++i) {
            cardsToLoad.add(cardInfo.createCard());
        }
        game.loadCards(cardsToLoad, owner.getId());
        return cardsToLoad;
    }

    private static void putCardToZone(Ability source, Game game, Player player, Card card, Zone zone) {
        switch (zone) {
            case BATTLEFIELD: {
                CardUtil.putCardOntoBattlefieldWithEffects((Ability)source, (Game)game, (Card)card, (Player)player, (boolean)false);
                break;
            }
            case LIBRARY: {
                card.setZone(Zone.LIBRARY, game);
                player.getLibrary().putOnTop(card, game);
                break;
            }
            case STACK: {
                card.cast(game, game.getState().getZone(card.getId()), card.getSpellAbility(), player.getId());
                break;
            }
            case EXILED: {
                card.setZone(Zone.EXILED, game);
                game.getExile().getPermanentExile().add(card);
                break;
            }
            case OUTSIDE: {
                card.setZone(Zone.OUTSIDE, game);
                break;
            }
            default: {
                card.moveToZone(zone, null, game, false);
            }
        }
        game.applyEffects();
        logger.info((Object)("Added card to player's " + zone.toString() + ": " + card.getName() + ", player = " + player.getName()));
    }

    public static boolean putPlaneToGame(Game game, Player player, String planeClassName) {
        Planes planeType;
        Plane plane;
        for (CommandObject comObject : game.getState().getCommand()) {
            if (!(comObject instanceof Plane)) continue;
            if (comObject.getAbilities() != null) {
                for (Ability ability : comObject.getAbilities()) {
                    for (Effect effect : ability.getEffects()) {
                        if (!(effect instanceof ContinuousEffect)) continue;
                        ((ContinuousEffect)effect).discard();
                    }
                }
            }
            game.getState().removeTriggersOfSourceId(comObject.getId());
            game.getState().getCommand().remove((Object)comObject);
            break;
        }
        if ((plane = Plane.createPlane((Planes)(planeType = Planes.fromClassName((String)planeClassName)))) != null) {
            game.addPlane(plane, player.getId());
            return true;
        }
        return false;
    }

    private static Optional<Player> findPlayer(Game game, String name) {
        return game.getPlayers().values().stream().filter(player -> player.getName().equals(name)).findFirst();
    }

    public static String sanitize(String input) {
        return input.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static List<String> parseSetAndCardNameCommand(String info) {
        Matcher matchInfo = patternCardInfo.matcher(info);
        String cardSet = "";
        String cardName = info;
        if (matchInfo.matches()) {
            cardSet = matchInfo.group(1);
            cardName = matchInfo.group(2);
        }
        return Arrays.asList(cardSet, cardName);
    }

    static {
        supportedCommands.put(COMMAND_CARDS_ADD_TO_HAND, "CARDS: ADD TO HAND");
        supportedCommands.put(COMMAND_MANA_ADD, "MANA ADD");
        supportedCommands.put(COMMAND_LANDS_ADD_TO_BATTLEFIELD, "LANDS: ADD TO BATTLEFIELD");
        supportedCommands.put(COMMAND_UNDER_CONTROL_TAKE, "UNDER CONTROL: TAKE");
        supportedCommands.put(COMMAND_UNDER_CONTROL_GIVE, "UNDER CONTROL: GIVE");
        supportedCommands.put(COMMAND_RUN_CUSTOM_CODE, "RUN CUSTOM CODE");
        supportedCommands.put(COMMAND_SHOW_OPPONENT_HAND, "SHOW OPPONENT HAND");
        supportedCommands.put(COMMAND_SHOW_OPPONENT_LIBRARY, "SHOW OPPONENT LIBRARY");
        supportedCommands.put(COMMAND_SHOW_MY_HAND, "SHOW MY HAND");
        supportedCommands.put(COMMAND_SHOW_MY_LIBRARY, "SHOW MY LIBRARY");
        supportedCommands.put(COMMAND_SHOW_TEST_DIALOGS, "SHOW TEST DIALOGS");
        patternGroup = Pattern.compile("\\[(.+)\\]");
        patternCommand = Pattern.compile("([\\w]+):([\\S ]+?):([\\S ]+):([\\d]+)");
        patternCardInfo = Pattern.compile("(^[\\dA-Z]{MIN,MAX})DELIMETER([\\S ]+)".replace("MIN", String.valueOf(3)).replace("MAX", String.valueOf(6)).replace("DELIMETER", "-"));
    }

    private static class CardCommandData {
        public String source;
        public String zone;
        public String player;
        public String cardName;
        public String cardSet;
        public Integer Amount;
        public Boolean OK;
        public String Error;

        private CardCommandData() {
        }
    }

    private static class CommandGroup {
        String name;
        boolean isSpecialCommand;
        List<String> commands = new ArrayList<String>();

        public CommandGroup(String name) {
            this(name, false);
        }

        public CommandGroup(String name, boolean isSpecialCommand) {
            this.name = name;
            this.isSpecialCommand = isSpecialCommand;
        }

        public String getPrintName() {
            if (this.isSpecialCommand && supportedCommands.containsKey(this.name)) {
                return (String)supportedCommands.get(this.name);
            }
            return this.name;
        }

        public String getPrintNameWithStats() {
            String res = this.getPrintName();
            if (!this.isSpecialCommand) {
                res = res + " (" + this.commands.size() + " commands)";
            }
            return res;
        }
    }
}

