/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.common.TargetPermanentOrPlayer;
import mage.utils.testers.TestableDialog;
import mage.utils.testers.TestableResult;

abstract class BaseTestableDialog
implements TestableDialog {
    private Integer regNumber;
    private final String group;
    private final String name;
    private final String description;
    private final TestableResult result;
    private static final FilterPermanent impossibleFilter = new FilterPermanent();

    public BaseTestableDialog(String group, String name, String description, TestableResult result) {
        this.group = group;
        this.name = name;
        this.description = description;
        this.result = result;
    }

    @Override
    public void setRegNumber(Integer regNumber) {
        this.regNumber = regNumber;
    }

    @Override
    public Integer getRegNumber() {
        return this.regNumber;
    }

    @Override
    public final String getGroup() {
        return this.group;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public void prepare() {
        this.result.onClear();
    }

    @Override
    public final void showResult(Player player, Game game) {
        game.informPlayer(player, String.join((CharSequence)"<br>", this.getResult().getResDetails()));
        game.firePriorityEvent(player.getId());
    }

    @Override
    public TestableResult getResult() {
        return this.result;
    }

    static Target createAnyTarget(int min, int max) {
        return BaseTestableDialog.createAnyTarget(min, max, false);
    }

    static Target createPlayerTarget(int min, int max, boolean notTarget) {
        return new TargetPlayer(min, max, notTarget);
    }

    private static Target createAnyTarget(int min, int max, boolean notTarget) {
        return new TargetPermanentOrPlayer(min, max).withNotTarget(notTarget);
    }

    static Target createImpossibleTarget(int min, int max) {
        return new TargetPermanent(min, max, impossibleFilter);
    }

    public String toString() {
        return this.getGroup() + " - " + this.getName() + " - " + this.getDescription();
    }

    static {
        impossibleFilter.add((Predicate)new ManaValuePredicate(ComparisonType.OR_LESS, -1));
    }
}

