/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.Targets;
import mage.target.common.TargetCardInHand;
import mage.util.DebugUtil;
import mage.utils.testers.BaseTestableDialog;
import mage.utils.testers.TargetTestableResult;
import mage.utils.testers.TestableDialogsRunner;

class ChooseCardsTestableDialog
extends BaseTestableDialog {
    TargetCard target;
    boolean isTargetChoice;
    boolean isYou;

    public ChooseCardsTestableDialog(boolean isTargetChoice, boolean notTarget, boolean isYou, String name, TargetCard target) {
        super(String.format("%s(%s, %s, cards)", isTargetChoice ? "player.chooseTarget" : "player.choose", isYou ? "you" : "AI", notTarget ? "not target" : "target"), name, target.toString(), new TargetTestableResult());
        this.isTargetChoice = isTargetChoice;
        this.target = target.withNotTarget(notTarget);
        this.isYou = isYou;
    }

    @Override
    public void showDialog(Player player, Ability source, Game game, Player opponent) {
        boolean chooseRes;
        String chooseDebugSource;
        TargetCard choosingTarget = this.target.copy();
        Player choosingPlayer = this.isYou ? player : opponent;
        ArrayList all = new ArrayList();
        all.addAll(choosingPlayer.getHand().getCards(game));
        CardsImpl choosingCards = new CardsImpl(all.stream().limit(100L).collect(Collectors.toList()));
        if (this.isTargetChoice) {
            chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
            chooseRes = choosingPlayer.chooseTarget(Outcome.Benefit, (Cards)choosingCards, choosingTarget, source, game);
        } else {
            chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
            chooseRes = choosingPlayer.choose(Outcome.Benefit, (Cards)choosingCards, choosingTarget, source, game);
        }
        ArrayList<String> res = new ArrayList<String>();
        if (chooseRes) {
            Targets.printDebugTargets((String)(this.getGroup() + " - " + this.getName() + " - TRUE"), (Targets)new Targets(new Target[]{choosingTarget}), (Ability)source, (Game)game, res);
        } else {
            Targets.printDebugTargets((String)(this.getGroup() + " - " + this.getName() + " - FALSE"), (Targets)new Targets(new Target[]{choosingTarget}), (Ability)source, (Game)game, res);
        }
        ((TargetTestableResult)this.getResult()).onFinish(chooseDebugSource, chooseRes, res, (Target)choosingTarget);
    }

    public static void register(TestableDialogsRunner runner) {
        FilterCard anyCard = StaticFilters.FILTER_CARD;
        FilterCard impossibleCard = new FilterCard();
        impossibleCard.add((Predicate)SubType.TROOPER.getPredicate());
        List<Boolean> notTargets = Arrays.asList(false, true);
        List<Boolean> isYous = Arrays.asList(false, true);
        List<Boolean> isTargetChoices = Arrays.asList(false, true);
        for (boolean notTarget : notTargets) {
            for (boolean isYou : isYous) {
                for (boolean isTargetChoice : isTargetChoices) {
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 0, X=0", (TargetCard)new TargetCardInHand(0, 0, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 1", (TargetCard)new TargetCardInHand(1, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 3", (TargetCard)new TargetCardInHand(3, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 9", (TargetCard)new TargetCardInHand(9, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 0-1", (TargetCard)new TargetCardInHand(0, 1, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 0-3", (TargetCard)new TargetCardInHand(0, 3, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 0-9", (TargetCard)new TargetCardInHand(0, 9, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand any", (TargetCard)new TargetCardInHand(0, Integer.MAX_VALUE, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 1-3", (TargetCard)new TargetCardInHand(1, 3, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 2-3", (TargetCard)new TargetCardInHand(2, 3, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 2-9", (TargetCard)new TargetCardInHand(2, 9, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "hand 8-9", (TargetCard)new TargetCardInHand(8, 9, anyCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible 0, X=0", (TargetCard)new TargetCardInHand(0, impossibleCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible 1", (TargetCard)new TargetCardInHand(1, impossibleCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible 3", (TargetCard)new TargetCardInHand(3, impossibleCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible 0-1", (TargetCard)new TargetCardInHand(0, 1, impossibleCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible 0-3", (TargetCard)new TargetCardInHand(0, 3, impossibleCard)));
                    runner.registerDialog(new ChooseCardsTestableDialog(isTargetChoice, notTarget, isYou, "impossible any", (TargetCard)new TargetCardInHand(0, Integer.MAX_VALUE, impossibleCard)));
                }
            }
        }
    }
}

