/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.utils.testers.AnnounceXTestableDialog;
import mage.utils.testers.ChooseAmountTestableDialog;
import mage.utils.testers.ChooseCardsTestableDialog;
import mage.utils.testers.ChooseChoiceTestableDialog;
import mage.utils.testers.ChoosePileTestableDialog;
import mage.utils.testers.ChooseTargetTestableDialog;
import mage.utils.testers.ChooseUseTestableDialog;
import mage.utils.testers.GetAmountTestableDialog;
import mage.utils.testers.GetMultiAmountTestableDialog;
import mage.utils.testers.TestableDialog;

public class TestableDialogsRunner {
    private final Map<Integer, TestableDialog> dialogs = new LinkedHashMap<Integer, TestableDialog>();
    static final int LAST_SELECTED_GROUP_ID = 997;
    static final int LAST_SELECTED_DIALOG_ID = 998;
    static String lastSelectedGroup = null;
    static TestableDialog lastSelectedDialog = null;

    public TestableDialogsRunner() {
        ChooseTargetTestableDialog.register(this);
        ChooseCardsTestableDialog.register(this);
        ChooseUseTestableDialog.register(this);
        ChooseChoiceTestableDialog.register(this);
        ChoosePileTestableDialog.register(this);
        ChooseAmountTestableDialog.register(this);
        AnnounceXTestableDialog.register(this);
        GetAmountTestableDialog.register(this);
        GetMultiAmountTestableDialog.register(this);
    }

    void registerDialog(TestableDialog dialog) {
        Integer regNumber = this.dialogs.size() + 1;
        dialog.setRegNumber(regNumber);
        this.dialogs.put(regNumber, dialog);
    }

    public void selectAndShowTestableDialog(Player player, Ability source, Game game, Player opponent) {
        List<String> groups = this.dialogs.values().stream().map(TestableDialog::getGroup).distinct().sorted().collect(Collectors.toList());
        Choice choice = this.prepareSelectGroupChoice(groups);
        player.choose(Outcome.Benefit, choice, game);
        String needGroup = null;
        TestableDialog needDialog = null;
        if (choice.getChoiceKey() != null) {
            int needIndex = Integer.parseInt(choice.getChoiceKey());
            if (needIndex == 997 && lastSelectedGroup != null) {
                needGroup = lastSelectedGroup;
            } else if (needIndex == 998 && lastSelectedDialog != null) {
                needGroup = lastSelectedDialog.getGroup();
                needDialog = lastSelectedDialog;
            } else if (needIndex < groups.size()) {
                needGroup = groups.get(needIndex);
            }
        }
        if (needGroup == null) {
            return;
        }
        if (needDialog == null) {
            choice = this.prepareSelectDialogChoice(needGroup);
            player.choose(Outcome.Benefit, choice, game);
            if (choice.getChoiceKey() != null) {
                int needRegNumber = Integer.parseInt(choice.getChoiceKey());
                needDialog = this.dialogs.getOrDefault(needRegNumber, null);
            }
        }
        if (needDialog == null) {
            return;
        }
        lastSelectedGroup = needGroup;
        lastSelectedDialog = needDialog;
        needDialog.prepare();
        needDialog.showDialog(player, source, game, opponent);
        needDialog.showResult(player, game);
    }

    private Choice prepareSelectGroupChoice(List<String> groups) {
        ChoiceImpl choice = new ChoiceImpl(false);
        choice.setMessage("Choose dialogs group to run");
        HashMap groupNumber = new HashMap();
        this.dialogs.values().forEach(dialog -> groupNumber.put(dialog.getGroup(), Math.min(groupNumber.getOrDefault(dialog.getGroup(), Integer.MAX_VALUE), dialog.getRegNumber())));
        for (int i = 0; i < groups.size(); ++i) {
            String group = groups.get(i);
            Integer groupMinNumber = groupNumber.getOrDefault(group, 0);
            choice.withItem(String.valueOf(i), String.format("%02d. %s", groupMinNumber, group), groupMinNumber, ChoiceHintType.TEXT, String.join((CharSequence)"<br>", group));
        }
        String lastGroupInfo = String.format(" -> last group: %s", lastSelectedGroup == null ? "not used" : lastSelectedGroup);
        choice.withItem(String.valueOf(997), lastGroupInfo, Integer.valueOf(-2), ChoiceHintType.TEXT, lastGroupInfo);
        String lastDialogName = lastSelectedDialog == null ? "not used" : String.format("%s - %s", lastSelectedDialog.getName(), lastSelectedDialog.getDescription());
        String lastDialogInfo = String.format(" -> last dialog: %s", lastDialogName);
        choice.withItem(String.valueOf(998), lastDialogInfo, Integer.valueOf(-1), ChoiceHintType.TEXT, lastDialogInfo);
        return choice;
    }

    private Choice prepareSelectDialogChoice(String needGroup) {
        ChoiceImpl choice = new ChoiceImpl(false);
        choice.setMessage("Choose game dialog to run from " + needGroup);
        for (TestableDialog dialog : this.dialogs.values()) {
            if (!dialog.getGroup().equals(needGroup)) continue;
            String info = String.format("%s - %s - %s", dialog.getGroup(), dialog.getName(), dialog.getDescription());
            choice.withItem(String.valueOf(dialog.getRegNumber()), String.format("%02d. %s", dialog.getRegNumber(), info), dialog.getRegNumber(), ChoiceHintType.TEXT, String.join((CharSequence)"<br>", info));
        }
        return choice;
    }

    public Collection<TestableDialog> getDialogs() {
        return this.dialogs.values();
    }
}

