/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import mage.game.command.Dungeon;
import mage.players.PlayableObjectStats;
import mage.view.CommandObjectView;

public class DungeonView
implements CommandObjectView,
Serializable {
    protected UUID id;
    protected String name;
    protected String imageFileName = "";
    protected int imageNumber = 0;
    protected String expansionSetCode = "";
    protected List<String> rules;
    protected PlayableObjectStats playableStats = new PlayableObjectStats();

    public DungeonView(Dungeon dungeon) {
        this.id = dungeon.getId();
        this.name = dungeon.getName();
        this.imageFileName = dungeon.getImageFileName();
        this.imageNumber = dungeon.getImageNumber();
        this.expansionSetCode = dungeon.getExpansionSetCode();
        this.rules = dungeon.getRules();
    }

    @Override
    public String getExpansionSetCode() {
        return this.expansionSetCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getImageFileName() {
        return this.imageFileName;
    }

    @Override
    public int getImageNumber() {
        return this.imageNumber;
    }

    @Override
    public List<String> getRules() {
        return this.rules;
    }

    @Override
    public boolean isPlayable() {
        return this.playableStats.getPlayableAmount() > 0;
    }

    @Override
    public void setPlayableStats(PlayableObjectStats playableStats) {
        this.playableStats = playableStats;
    }

    @Override
    public PlayableObjectStats getPlayableStats() {
        return this.playableStats;
    }

    @Override
    public boolean isChoosable() {
        return false;
    }

    @Override
    public void setChoosable(boolean isChoosable) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean isSelected) {
    }
}

