/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.InvocationFailureException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.socket.MicroSocketClientInvoker;
import org.jboss.remoting.transport.socket.OpenConnectionChecker;
import org.jboss.remoting.transport.socket.ServerAddress;
import org.jboss.remoting.transport.socket.SocketWrapper;
import org.jboss.remoting.util.SecurityUtility;

public class SocketClientInvoker
extends MicroSocketClientInvoker {
    private static final Logger log = Logger.getLogger((Class)SocketClientInvoker.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    public static final String SO_TIMEOUT_FLAG = "timeout";
    public static final int SO_TIMEOUT_DEFAULT = 1800000;
    protected int timeout = 1800000;
    private Constructor clientSocketConstructor = null;

    public SocketClientInvoker(InvokerLocator locator) {
        this(locator, null);
    }

    public SocketClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
        this.configureParameters();
    }

    protected ServerAddress createServerAddress(InetAddress addr, int port) {
        return new ServerAddress(addr.getHostAddress(), port, this.enableTcpNoDelay, this.timeout, this.maxPoolSize);
    }

    protected void configureParameters() {
        Object val;
        super.configureParameters();
        this.timeout = 1800000;
        Map params = this.configuration;
        if (params != null && (val = params.get(SO_TIMEOUT_FLAG)) != null) {
            try {
                this.timeout = Integer.valueOf((String)val);
                log.debug((Object)(this + " setting timeout to " + this.timeout));
            }
            catch (Exception e) {
                log.warn((Object)(this + " could not convert " + SO_TIMEOUT_FLAG + " value of " + val + " to a int value."));
            }
        }
    }

    protected Object handleException(Exception ex, SocketWrapper socketWrapper) throws ClassNotFoundException, InvocationFailureException, CannotConnectException {
        if (ex instanceof ClassNotFoundException) {
            log.debug((Object)"Error loading classes from remote call result.", (Throwable)ex);
            throw (ClassNotFoundException)ex;
        }
        if (ex instanceof CannotConnectException) {
            log.debug((Object)this, (Throwable)ex);
            throw (CannotConnectException)ex;
        }
        if (ex instanceof SocketTimeoutException) {
            log.debug((Object)"Got SocketTimeoutException, exiting", (Throwable)ex);
            String message = "Socket timed out.  Waited " + socketWrapper.getTimeout() + " milliseconds for response while calling on " + this.getLocator();
            throw new InvocationFailureException(message, ex);
        }
        if (ex instanceof InterruptedException) {
            log.debug((Object)this, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        throw new InvocationFailureException("Unable to perform invocation", ex);
    }

    protected SocketWrapper createClientSocket(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.clientSocketConstructor == null) {
            if (this.clientSocketClass == null) {
                this.clientSocketClass = ClassLoaderUtility.loadClass(this.getClass(), this.clientSocketClassName);
            }
            try {
                this.clientSocketConstructor = this.clientSocketClass.getConstructor(Socket.class, Map.class, Integer.class);
            }
            catch (NoSuchMethodException e) {
                this.clientSocketConstructor = this.clientSocketClass.getConstructor(Socket.class);
            }
        }
        SocketWrapper clientSocketWrapper = null;
        if (this.clientSocketConstructor.getParameterTypes().length == 3) {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket, metadata, new Integer(timeout));
        } else {
            clientSocketWrapper = (SocketWrapper)this.clientSocketConstructor.newInstance(socket);
            clientSocketWrapper.setTimeout(timeout);
        }
        return clientSocketWrapper;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Socket s = null;
        SocketFactory socketFactory = this.getSocketFactory();
        s = socketFactory != null ? socketFactory.createSocket() : new Socket();
        this.configureSocket(s);
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        SocketClientInvoker.connect(s, inetAddr, timeout);
        return s;
    }

    protected SocketWrapper getPooledConnection() {
        SocketWrapper socketWrapper = null;
        while (this.pool.size() > 0) {
            socketWrapper = (SocketWrapper)this.pool.removeFirst();
            try {
                if (socketWrapper == null) continue;
                if (socketWrapper instanceof OpenConnectionChecker) {
                    ((OpenConnectionChecker)((Object)socketWrapper)).checkOpenConnection();
                }
                if (this.shouldCheckConnection) {
                    socketWrapper.checkConnection();
                    return socketWrapper;
                }
                if (socketWrapper.getSocket().isConnected()) {
                    return socketWrapper;
                }
                try {
                    socketWrapper.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception ex) {
                if (isTraceEnabled) {
                    log.trace((Object)"Couldn't reuse connection from pool", (Throwable)ex);
                }
                try {
                    socketWrapper.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "SocketClientInvoker[" + Integer.toHexString(System.identityHashCode(this)) + ", " + this.locator.getProtocol() + "://" + this.locator.getHost() + ":" + this.locator.getPort() + "]";
    }

    private static void connect(final Socket socket, final InetSocketAddress address, final int timeout) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            socket.connect(address, timeout);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    socket.connect(address, timeout);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

