/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.WillCloseWhenClosed;

public abstract class DecoratingOutputStream
extends OutputStream {
    @Nullable
    @WillCloseWhenClosed
    protected OutputStream out;

    protected DecoratingOutputStream() {
    }

    protected DecoratingOutputStream(@WillCloseWhenClosed OutputStream out) {
        this.out = Objects.requireNonNull(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        this.out.close();
    }

    public String toString() {
        return String.format("%s[out=%s]", this.getClass().getName(), this.out);
    }
}

