/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import javax.annotation.concurrent.Immutable;

@Immutable
final class ThreadGroups {
    private ThreadGroups() {
    }

    public static ThreadGroup getThreadGroup() {
        SecurityManager sm = System.getSecurityManager();
        return null != sm ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    public static ThreadGroup getServerThreadGroup() {
        ThreadGroup ntg;
        ThreadGroup tg = ThreadGroups.getThreadGroup();
        while (null != (ntg = tg.getParent())) {
            try {
                ntg.checkAccess();
            }
            catch (SecurityException ex) {
                break;
            }
            tg = ntg;
        }
        return tg;
    }
}

