/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.player.ai.CombatEvaluator;

public class PermanentEvaluator {
    private final Map<UUID, Integer> values = new HashMap<UUID, Integer>();
    private final CombatEvaluator combat = new CombatEvaluator();

    public int evaluate(Permanent permanent, Game game) {
        if (!this.values.containsKey(permanent.getId())) {
            int value = 0;
            if (permanent.isCreature(game)) {
                value += this.combat.evaluate(permanent, game);
            }
            if (permanent.isPlaneswalker(game)) {
                value += 2 * permanent.getCounters(game).getCount(CounterType.LOYALTY);
            }
            value += permanent.getAbilities().getActivatedManaAbilities(Zone.BATTLEFIELD).size();
            this.values.put(permanent.getId(), value += permanent.getAbilities().getActivatedAbilities(Zone.BATTLEFIELD).size());
        }
        return this.values.get(permanent.getId());
    }
}

