/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.Comparator;
import java.util.UUID;
import mage.MageItem;
import mage.MageObject;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.player.ai.PossibleTargetsSelector;
import mage.player.ai.score.GameStateEvaluator2;
import mage.players.PlayableObjectsList;
import mage.players.Player;

public class PossibleTargetsComparator {
    UUID abilityControllerId;
    Game game;
    PlayableObjectsList playableItems = new PlayableObjectsList();
    private final Comparator<MageItem> BY_NAME = (o1, o2) -> this.getName((MageItem)o2).compareTo(this.getName((MageItem)o1));
    private final Comparator<MageItem> BY_ID = Comparator.comparing(MageItem::getId);
    private final Comparator<MageItem> BY_ME = (o1, o2) -> Boolean.compare(this.isMyItem((MageItem)o2), this.isMyItem((MageItem)o1));
    private final Comparator<MageItem> BY_BIGGER_SCORE = (o1, o2) -> Integer.compare(this.getScoreFromBattlefield((MageItem)o2), this.getScoreFromBattlefield((MageItem)o1));
    private final Comparator<MageItem> BY_PLAYABLE = (o1, o2) -> Boolean.compare(this.playableItems.containsObject(o2.getId()), this.playableItems.containsObject(o1.getId()));
    private final Comparator<MageItem> BY_LAND = (o1, o2) -> {
        boolean isLand1 = o1 instanceof MageObject && ((MageObject)o1).isLand(this.game);
        boolean isLand2 = o2 instanceof MageObject && ((MageObject)o2).isLand(this.game);
        return Boolean.compare(isLand2, isLand1);
    };
    private final Comparator<MageItem> BY_TYPE_PLAYER = (o1, o2) -> Boolean.compare(o2 instanceof Player, o1 instanceof Player);
    private final Comparator<MageItem> BY_TYPE_PLANESWALKER = (o1, o2) -> {
        boolean isPlaneswalker1 = o1 instanceof MageObject && ((MageObject)o1).isPlaneswalker(this.game);
        boolean isPlaneswalker2 = o2 instanceof MageObject && ((MageObject)o2).isPlaneswalker(this.game);
        return Boolean.compare(isPlaneswalker2, isPlaneswalker1);
    };
    private final Comparator<MageItem> BY_TYPE_BATTLE = (o1, o2) -> {
        boolean isBattle1 = o1 instanceof MageObject && ((MageObject)o1).isBattle(this.game);
        boolean isBattle2 = o2 instanceof MageObject && ((MageObject)o2).isBattle(this.game);
        return Boolean.compare(isBattle2, isBattle1);
    };
    private final Comparator<MageItem> BY_TYPES = this.BY_TYPE_PLANESWALKER.thenComparing(this.BY_TYPE_BATTLE).thenComparing(this.BY_TYPE_PLAYER);
    public final Comparator<MageItem> ANY_MOST_VALUABLE_FIRST = this.BY_TYPES.thenComparing(this.BY_BIGGER_SCORE).thenComparing(this.BY_NAME).thenComparing(this.BY_ID);
    public final Comparator<MageItem> ANY_MOST_VALUABLE_LAST = this.ANY_MOST_VALUABLE_FIRST.reversed();
    public final Comparator<MageItem> ANY_UNPLAYABLE_AND_USELESS = this.BY_LAND.reversed().thenComparing(this.BY_PLAYABLE.reversed()).thenComparing(this.ANY_MOST_VALUABLE_FIRST);

    public PossibleTargetsComparator(UUID abilityControllerId, Game game) {
        this.abilityControllerId = abilityControllerId;
        this.game = game;
    }

    public void findPlayableItems() {
        this.playableItems = this.game.getPlayer(this.abilityControllerId).getPlayableObjects(this.game, Zone.ALL);
    }

    private int getScoreFromBattlefield(MageItem item) {
        if (item instanceof Permanent) {
            return GameStateEvaluator2.evaluatePermanent((Permanent)item, this.game, false);
        }
        return this.getScoreFromLife(item);
    }

    private String getName(MageItem item) {
        if (item instanceof Player) {
            return ((Player)item).getName();
        }
        if (item instanceof MageObject) {
            return ((MageObject)item).getName();
        }
        return "unknown";
    }

    public static int getLifeForDamage(MageItem item, Game game) {
        int res = 0;
        if (item instanceof Player) {
            res = ((Player)item).getLife();
        } else if (item instanceof Card) {
            Card card = (Card)item;
            if (card.isPlaneswalker(game)) {
                res = card.getCounters(game).getCount(CounterType.LOYALTY);
            } else if (card.isBattle(game)) {
                res = card.getCounters(game).getCount(CounterType.DEFENSE);
            } else {
                int damage = 0;
                if (card instanceof Permanent) {
                    damage = ((Permanent)card).getDamage();
                }
                res = Math.max(0, card.getToughness().getValue() - damage);
            }
        }
        return res;
    }

    private int getScoreFromLife(MageItem item) {
        int res = PossibleTargetsComparator.getLifeForDamage(item, this.game);
        if (res == 0 && item instanceof Card) {
            res = ((Card)item).getManaValue();
        }
        return res;
    }

    private boolean isMyItem(MageItem item) {
        return PossibleTargetsSelector.isMyItem(this.abilityControllerId, item);
    }
}

