/*
 * Decompiled with CFR 0.152.
 */
package mage.player.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ControllableOrOwnerable;
import mage.game.Game;
import mage.player.ai.PossibleTargetsComparator;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyardBattlefieldOrStack;
import mage.target.common.TargetDiscard;

public class PossibleTargetsSelector {
    Outcome outcome;
    Target target;
    UUID abilityControllerId;
    Ability source;
    Game game;
    PossibleTargetsComparator comparators;
    List<MageItem> me = new ArrayList<MageItem>();
    List<MageItem> opponents = new ArrayList<MageItem>();
    List<MageItem> any = new ArrayList<MageItem>();

    public PossibleTargetsSelector(Outcome outcome, Target target, UUID abilityControllerId, Ability source, Game game) {
        this.outcome = outcome;
        this.target = target;
        this.abilityControllerId = abilityControllerId;
        this.source = source;
        this.game = game;
        this.comparators = new PossibleTargetsComparator(abilityControllerId, game);
    }

    public void findNewTargets(Set<UUID> fromTargetsList) {
        List<MageItem> found = this.target.possibleTargets(this.abilityControllerId, this.source, this.game, fromTargetsList).stream().filter(id -> !this.target.contains(id)).map(id -> {
            Player player = this.game.getPlayer(id);
            if (player != null) {
                return player;
            }
            return this.game.getObject(id);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        found.forEach(item -> {
            if (PossibleTargetsSelector.isMyItem(this.abilityControllerId, item)) {
                this.me.add((MageItem)item);
            } else {
                this.opponents.add((MageItem)item);
            }
            this.any.add((MageItem)item);
        });
        if (this.target instanceof TargetDiscard) {
            this.sortByUnplayableAndUseless();
        } else {
            this.sortByMostValuableTargets();
        }
    }

    private void sortByMostValuableTargets() {
        if (this.isGoodEffect()) {
            this.me.sort(this.comparators.ANY_MOST_VALUABLE_FIRST);
            this.opponents.sort(this.comparators.ANY_MOST_VALUABLE_LAST);
            this.any.sort(this.comparators.ANY_MOST_VALUABLE_FIRST);
        } else {
            this.me.sort(this.comparators.ANY_MOST_VALUABLE_LAST);
            this.opponents.sort(this.comparators.ANY_MOST_VALUABLE_FIRST);
            this.any.sort(this.comparators.ANY_MOST_VALUABLE_LAST);
        }
    }

    private void sortByUnplayableAndUseless() {
        this.comparators.findPlayableItems();
        this.me.sort(this.comparators.ANY_UNPLAYABLE_AND_USELESS);
        this.opponents.sort(this.comparators.ANY_UNPLAYABLE_AND_USELESS);
        this.any.sort(this.comparators.ANY_UNPLAYABLE_AND_USELESS);
    }

    public List<MageItem> getGoodTargets() {
        if (this.isAnyEffect()) {
            return this.any;
        }
        if (this.isGoodEffect()) {
            return this.me;
        }
        return this.opponents;
    }

    public List<MageItem> getBadTargets() {
        if (this.isAnyEffect()) {
            return Collections.emptyList();
        }
        if (this.isGoodEffect()) {
            return this.opponents;
        }
        return this.me;
    }

    public List<MageItem> getAny() {
        return this.any;
    }

    public static boolean isMyItem(UUID abilityControllerId, MageItem item) {
        if (item instanceof Player) {
            return item.getId().equals(abilityControllerId);
        }
        if (item instanceof ControllableOrOwnerable) {
            return ((ControllableOrOwnerable)item).getControllerOrOwnerId().equals(abilityControllerId);
        }
        return false;
    }

    private boolean isAnyEffect() {
        boolean isAnyEffect = this.outcome.anyTargetHasSameValue();
        if (this.hasGoodExile()) {
            isAnyEffect = true;
        }
        return isAnyEffect;
    }

    private boolean isGoodEffect() {
        boolean isGoodEffect = this.outcome.isGood();
        if (this.hasGoodExile()) {
            isGoodEffect = true;
        }
        return isGoodEffect;
    }

    private boolean hasGoodExile() {
        return this.outcome == Outcome.Exile && (Zone.GRAVEYARD.match(this.target.getZone()) || Zone.LIBRARY.match(this.target.getZone())) && !(this.target instanceof TargetCardInGraveyardBattlefieldOrStack);
    }

    public boolean hasAnyTargets() {
        return !this.any.isEmpty();
    }

    public boolean hasMinNumberOfTargets() {
        return this.target.getMinNumberOfTargets() == 0 || this.any.size() >= this.target.getMinNumberOfTargets();
    }
}

