/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetlang.channels.BatchCallback;
import org.jetlang.channels.BatchTimeout;
import org.jetlang.channels.RequestChannel;
import org.jetlang.channels.SingleReply;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.fibers.Fiber;

public class AsyncRequest<R, V> {
    private Fiber target;
    private BatchTimeout<V> timeout;
    private int responses = 1;

    public AsyncRequest(Fiber target) {
        this.target = target;
    }

    public AsyncRequest<R, V> setTimeout(Callback<List<V>> onTimeout, long time, TimeUnit unit) {
        this.timeout = new BatchTimeout<V>(onTimeout, time, unit);
        return this;
    }

    public AsyncRequest<R, V> setResponseCount(int responses) {
        this.responses = responses;
        return this;
    }

    public Disposable publish(RequestChannel<R, V> channel, R req, Callback<List<V>> onResponse) {
        BatchCallback<R, V> callback = new BatchCallback<R, V>(this.responses, onResponse, this.timeout);
        callback.send(channel, req, this.target);
        return callback;
    }

    public static <R, V> Disposable withOneReply(Fiber fiber, RequestChannel<R, V> channel, R req, Callback<V> onReply) {
        return SingleReply.publish(fiber, channel, req, onReply);
    }

    public static <R, V> Disposable withOneReply(Fiber fiber, RequestChannel<R, V> channel, R req, Callback<V> onReply, long timeout, TimeUnit unit, Runnable onTimeout) {
        return SingleReply.publish(fiber, channel, req, onReply, timeout, unit, onTimeout);
    }
}

