/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.ArrayList;
import java.util.List;
import org.jetlang.channels.BatchTimeout;
import org.jetlang.channels.RequestChannel;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.fibers.Fiber;

class BatchCallback<R, V>
implements Callback<V>,
Runnable,
Disposable {
    private final Object lock = new Object();
    private final List<V> results = new ArrayList<V>();
    private final int responses;
    private final Callback<List<V>> onComplete;
    private final BatchTimeout<V> timeout;
    private Disposable d;

    public BatchCallback(int responses, Callback<List<V>> onComplete, BatchTimeout<V> timeout) {
        this.responses = responses;
        this.onComplete = onComplete;
        this.timeout = timeout;
    }

    @Override
    public void onMessage(V message) {
        this.results.add(message);
        if (this.responses > 0 && this.results.size() == this.responses) {
            this.dispose();
            this.onComplete.onMessage(this.results);
        }
    }

    @Override
    public void run() {
        this.dispose();
        this.timeout.cb.onMessage(this.results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.d != null) {
                this.d.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(RequestChannel<R, V> channel, R req, Fiber target) {
        Object object = this.lock;
        synchronized (object) {
            final Disposable requestDispose = channel.publish(target, req, this);
            if (this.timeout != null) {
                final Disposable timer = target.schedule(this, this.timeout.time, this.timeout.unit);
                this.d = new Disposable(){

                    @Override
                    public void dispose() {
                        requestDispose.dispose();
                        timer.dispose();
                    }
                };
            } else {
                this.d = requestDispose;
            }
        }
    }
}

