/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import org.jetlang.channels.Channel;
import org.jetlang.channels.Subscribable;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.core.DisposingExecutor;

public class CompositeChannel<T>
implements Channel<T> {
    private final Channel<T>[] channels;

    public CompositeChannel(Channel<T> ... channels) {
        this.channels = channels;
    }

    @Override
    public Disposable subscribe(DisposingExecutor executor, Callback<T> receive) {
        final Disposable[] all = new Disposable[this.channels.length];
        Disposable d = new Disposable(){

            @Override
            public void dispose() {
                for (Disposable disposable : all) {
                    disposable.dispose();
                }
            }
        };
        for (int i = 0; i < this.channels.length; ++i) {
            all[i] = this.channels[i].subscribe(executor, receive);
        }
        return d;
    }

    @Override
    public Disposable subscribe(Subscribable<T> sub) {
        final Disposable[] all = new Disposable[this.channels.length];
        Disposable d = new Disposable(){

            @Override
            public void dispose() {
                for (Disposable disposable : all) {
                    disposable.dispose();
                }
            }
        };
        for (int i = 0; i < this.channels.length; ++i) {
            all[i] = this.channels[i].subscribe(sub);
        }
        return d;
    }

    @Override
    public void publish(T msg) {
        for (Channel<T> channel : this.channels) {
            channel.publish(msg);
        }
    }
}

