/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jetlang.channels.MemoryChannel;
import org.jetlang.channels.Request;
import org.jetlang.channels.RequestChannel;
import org.jetlang.channels.Session;
import org.jetlang.channels.SessionClosed;
import org.jetlang.channels.SessionClosedImpl;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.core.DisposingExecutor;

public class MemoryRequestChannel<R, V>
implements RequestChannel<R, V> {
    private final MemoryChannel<Request<R, V>> channel = new MemoryChannel();
    private final MemoryChannel<SessionClosed<R>> endChannel = new MemoryChannel();

    @Override
    public Disposable subscribe(DisposingExecutor fiber, Callback<Request<R, V>> onRequest) {
        return this.channel.subscribe(fiber, onRequest);
    }

    @Override
    public Disposable subscribe(DisposingExecutor fiber, Callback<Request<R, V>> onRequest, Callback<SessionClosed<R>> onRequestEnd) {
        final Disposable sub = this.channel.subscribe(fiber, onRequest);
        final Disposable end = this.endChannel.subscribe(fiber, onRequestEnd);
        return new Disposable(){

            @Override
            public void dispose() {
                sub.dispose();
                end.dispose();
            }
        };
    }

    @Override
    public Disposable publish(DisposingExecutor target, final R request, Callback<V> reply) {
        final RequestImpl req = new RequestImpl(target, request, reply);
        this.channel.publish(req);
        return new Disposable(){

            @Override
            public void dispose() {
                if (req.dispose()) {
                    SessionClosedImpl<Object> end = new SessionClosedImpl<Object>(request, req.getSession());
                    MemoryRequestChannel.this.endChannel.publish(end);
                }
            }
        };
    }

    private class RequestImpl
    implements Request<R, V> {
        private final DisposingExecutor target;
        private final R request;
        private final Callback<V> reply;
        private final AtomicBoolean disposed = new AtomicBoolean(false);
        private final Session session = new SessionImpl();

        public RequestImpl(DisposingExecutor target, R request, Callback<V> reply) {
            this.target = target;
            this.request = request;
            this.reply = reply;
        }

        @Override
        public Session getSession() {
            return this.session;
        }

        @Override
        public R getRequest() {
            return this.request;
        }

        @Override
        public void reply(final V msg) {
            Runnable onMsg = new Runnable(){

                @Override
                public void run() {
                    RequestImpl.this.consumeMsg(msg);
                }
            };
            this.target.execute(onMsg);
        }

        private void consumeMsg(V msg) {
            if (this.disposed.get()) {
                return;
            }
            this.reply.onMessage(msg);
        }

        public boolean dispose() {
            return this.disposed.compareAndSet(false, true);
        }
    }

    private static class SessionImpl
    implements Session {
        private SessionImpl() {
        }
    }
}

