/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetlang.channels.BaseSubscription;
import org.jetlang.core.Callback;
import org.jetlang.core.Filter;
import org.jetlang.core.MessageBuffer;
import org.jetlang.core.MessageReader;
import org.jetlang.fibers.Fiber;

public class RecyclingBatchSubscriber<T>
extends BaseSubscription<T> {
    private final Lock _lock = new ReentrantLock();
    private final Fiber _queue;
    private final Callback<MessageReader<T>> _receive;
    private final int _interval;
    private final TimeUnit _timeUnit;
    private MessageBuffer<T> _pending = new MessageBuffer();
    private MessageBuffer<T> _active = new MessageBuffer();
    private final Runnable _flushRunnable;

    public RecyclingBatchSubscriber(Fiber queue, Callback<MessageReader<T>> receive, Filter<T> filter, int interval, TimeUnit timeUnit) {
        super(queue, filter);
        this._queue = queue;
        this._receive = receive;
        this._interval = interval;
        this._timeUnit = timeUnit;
        this._flushRunnable = new Runnable(){

            @Override
            public void run() {
                RecyclingBatchSubscriber.this.flush();
            }

            public String toString() {
                return "Flushing " + RecyclingBatchSubscriber.this + " via " + RecyclingBatchSubscriber.this._receive.toString();
            }
        };
    }

    public RecyclingBatchSubscriber(Fiber queue, Callback<MessageReader<T>> receive, int interval, TimeUnit timeUnit) {
        this(queue, receive, null, interval, timeUnit);
    }

    @Override
    protected void onMessageOnProducerThread(T msg) {
        this._lock.lock();
        try {
            if (this._pending.isEmpty()) {
                this._queue.schedule(this._flushRunnable, this._interval, this._timeUnit);
            }
            this._pending.add(msg);
        }
        finally {
            this._lock.unlock();
        }
    }

    private void flush() {
        this._lock.lock();
        try {
            MessageBuffer<T> nowPending = this._active;
            this._active = this._pending;
            this._pending = nowPending;
        }
        finally {
            this._lock.unlock();
        }
        try {
            this._receive.onMessage(this._active);
        }
        finally {
            this._active.clear();
        }
    }
}

