/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.channels;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetlang.core.Callback;

public class SubscriberList<T> {
    private static final Callback[] EMPTY = new Callback[0];
    private volatile Callback<T>[] subscribers = EMPTY;
    private final Lock lock = new ReentrantLock();

    public void add(Callback<T> cb) {
        this.lock.lock();
        try {
            Callback[] resized = new Callback[this.subscribers.length + 1];
            System.arraycopy(this.subscribers, 0, resized, 0, this.subscribers.length);
            resized[this.subscribers.length] = cb;
            this.subscribers = resized;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        return this.subscribers.length;
    }

    public void clear() {
        this.lock.lock();
        try {
            this.subscribers = EMPTY;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Callback<T> cb) {
        this.lock.lock();
        try {
            int i;
            int index = -1;
            Callback<T>[] cbs = this.subscribers;
            for (i = 0; i < cbs.length; ++i) {
                if (!cbs[i].equals(cb)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                i = 0;
                return i != 0;
            }
            Callback[] resized = new Callback[this.subscribers.length - 1];
            System.arraycopy(this.subscribers, 0, resized, 0, index);
            if (index != resized.length) {
                System.arraycopy(this.subscribers, index + 1, resized, index, resized.length - index);
            }
            this.subscribers = resized;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void publish(T msg) {
        SubscriberList.executeAll(msg, this.subscribers);
    }

    private static <V> void executeAll(V msg, Callback<V>[] cbs) {
        for (Callback<V> cb : cbs) {
            cb.onMessage(msg);
        }
    }
}

