/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.nio.channels.Selector;
import org.jetlang.core.EventBuffer;

public class QueueSwapper {
    private final Selector sink;
    private EventBuffer _queue = new EventBuffer();
    private boolean running = true;

    public QueueSwapper(Selector sink) {
        this.sink = sink;
    }

    public synchronized void put(Runnable r) {
        if (!this.running) {
            return;
        }
        this._queue.add(r);
        if (this._queue.size() == 1) {
            this.sink.wakeup();
        }
    }

    public synchronized EventBuffer swap(EventBuffer buffer) {
        EventBuffer toReturn = this._queue;
        this._queue = buffer;
        return toReturn;
    }

    public synchronized int size() {
        return this._queue.size();
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }
}

