/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.core;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetlang.core.EventBuffer;
import org.jetlang.core.EventQueue;

public class RunnableBlockingQueue
implements EventQueue {
    private volatile boolean _running = true;
    private final Lock _lock = new ReentrantLock();
    private final Condition _waiter = this._lock.newCondition();
    private EventBuffer _queue = new EventBuffer();

    @Override
    public boolean isRunning() {
        return this._running;
    }

    @Override
    public void setRunning(boolean isRunning) {
        this._running = isRunning;
    }

    @Override
    public void put(Runnable r) {
        this._lock.lock();
        try {
            this._queue.add(r);
            this._waiter.signal();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventBuffer swap(EventBuffer buffer) {
        this._lock.lock();
        try {
            while (this._queue.isEmpty() && this._running) {
                try {
                    this._waiter.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            EventBuffer toReturn = this._queue;
            this._queue = buffer;
            EventBuffer eventBuffer = toReturn;
            return eventBuffer;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this._lock.lock();
        try {
            boolean bl = this._queue.isEmpty();
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }
}

