/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.fibers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetlang.core.Callback;
import org.jetlang.core.Disposable;
import org.jetlang.core.EventBuffer;
import org.jetlang.core.QueueSwapper;
import org.jetlang.core.SchedulerImpl;
import org.jetlang.fibers.NioBatchExecutor;
import org.jetlang.fibers.NioBatchExecutorImpl;
import org.jetlang.fibers.NioChannelHandler;
import org.jetlang.fibers.NioControls;
import org.jetlang.fibers.NioFiber;

public class NioFiberImpl
implements Runnable,
NioFiber {
    private final SchedulerImpl scheduler;
    private boolean selectorRunning = true;
    private final Selector selector;
    private final Map<SelectableChannel, NioState> handlers = new IdentityHashMap<SelectableChannel, NioState>();
    private final List<Disposable> _disposables = Collections.synchronizedList(new ArrayList());
    private final QueueSwapper queue;
    private final Thread thread;
    private final NioBatchExecutor executor;
    private final WriteFailure writeFailed;
    private final OnBuffer onBuffer;
    private final NioControls controls = new NioControls(){

        @Override
        public Selector getSelector() {
            return NioFiberImpl.this.selector;
        }

        @Override
        public boolean isRegistered(SelectableChannel channel) {
            return NioFiberImpl.this.handlers.containsKey(channel);
        }

        @Override
        public void addHandler(NioChannelHandler handler) {
            NioFiberImpl.this.synchronousAdd(handler);
        }

        @Override
        public <T extends SelectableChannel> void write(T accept, ByteBuffer buffer) {
            NioState key = (NioState)NioFiberImpl.this.handlers.get(accept);
            try {
                if (key == null || key.buffer == null) {
                    NioFiberImpl.writeAll((WritableByteChannel)((Object)accept), buffer);
                    if (buffer.remaining() == 0) {
                        return;
                    }
                }
            }
            catch (IOException e) {
                NioFiberImpl.this.writeFailed.onFailure(e, accept, buffer);
                return;
            }
            if (key == null) {
                NioStateWrite<T> handler = new NioStateWrite<T>(accept, NioFiberImpl.this.writeFailed, NioFiberImpl.this.onBuffer);
                key = NioFiberImpl.this.synchronousAdd(handler);
                if (key == null) {
                    return;
                }
                key.buffer = handler;
                handler.state = key;
            } else if (key.buffer == null) {
                NioStateWrite<T> handler = new NioStateWrite<T>(accept, NioFiberImpl.this.writeFailed, NioFiberImpl.this.onBuffer);
                if (key.attemptUpdateInterest(handler.getInterestSet())) {
                    handler.state = key;
                    key.buffer = handler;
                    key.handlers.add(handler);
                } else {
                    return;
                }
            }
            key.addToBuffer(buffer);
        }

        @Override
        public boolean close(SelectableChannel channel) {
            NioFiberImpl.this.closeQuietly(channel);
            NioState nioState = (NioState)NioFiberImpl.this.handlers.remove(channel);
            if (nioState != null) {
                nioState.onEnd();
                return true;
            }
            return false;
        }
    };

    private void closeQuietly(SelectableChannel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeAll(WritableByteChannel channel, ByteBuffer data) throws IOException {
        int write;
        while ((write = channel.write(data)) != 0 && data.remaining() > 0) {
        }
    }

    public static void removeInterestFrom(NioChannelHandler handler, SelectionKey key) {
        key.interestOps(key.interestOps() & ~handler.getInterestSet());
    }

    public NioFiberImpl() {
        this(new NioBatchExecutorImpl(), Collections.emptyList());
    }

    public NioFiberImpl(NioBatchExecutor executor, Collection<NioChannelHandler> handlers) {
        this(executor, handlers, "nioFiber", true, new NoOpWriteFailure(), new NoOpBuffer());
    }

    public NioFiberImpl(NioBatchExecutor executor, Collection<NioChannelHandler> nioHandlers, String threadName, boolean isDaemonThread, WriteFailure writeFailed, OnBuffer onBuffer) {
        this.executor = executor;
        this.writeFailed = writeFailed;
        this.onBuffer = onBuffer;
        this.scheduler = new SchedulerImpl(this);
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (NioChannelHandler nioHandler : nioHandlers) {
            this.synchronousAdd(nioHandler);
        }
        this.queue = new QueueSwapper(this.selector);
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.setDaemon(isDaemonThread);
    }

    public Thread getThread() {
        return this.thread;
    }

    public static ByteBuffer addTo(ByteBuffer data, ByteBuffer buffer) {
        int size = buffer.remaining();
        if (data == null) {
            data = ByteBuffer.allocate(size);
            data.put(buffer);
            data.flip();
        } else {
            data.compact();
            if (data.position() + size > data.capacity()) {
                ByteBuffer b = ByteBuffer.allocate(data.capacity() + size);
                data.flip();
                b.put(data);
                data = b;
            }
            data.put(buffer);
            data.flip();
        }
        return data;
    }

    @Override
    public void execute(Runnable command) {
        this.queue.put(command);
    }

    @Override
    public void addHandler(final NioChannelHandler handler) {
        if (this.onSelectorThread()) {
            this.synchronousAdd(handler);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioFiberImpl.this.synchronousAdd(handler);
                }
            });
        }
    }

    @Override
    public void close(final SelectableChannel channel) {
        if (this.onSelectorThread()) {
            this.controls.close(channel);
        } else {
            this.execute(new Callback<NioControls>(){

                @Override
                public void onMessage(NioControls message) {
                    NioFiberImpl.this.controls.close(channel);
                }
            });
        }
    }

    @Override
    public boolean onSelectorThread() {
        return Thread.currentThread() == this.thread;
    }

    @Override
    public void execute(final Callback<NioControls> asyncWrite) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                asyncWrite.onMessage(NioFiberImpl.this.controls);
            }
        });
    }

    private NioState synchronousAdd(NioChannelHandler handler) {
        try {
            SelectableChannel channel = handler.getChannel();
            channel.configureBlocking(false);
            int interestSet = handler.getInterestSet();
            NioState nioState = this.handlers.get(channel);
            if (nioState != null) {
                if (!nioState.attemptUpdateInterest(interestSet)) {
                    handler.onEnd();
                    return null;
                }
                nioState.handlers.add(handler);
                return nioState;
            }
            NioState value = new NioState(channel);
            value.key = channel.register(this.selector, interestSet, value);
            value.handlers.add(handler);
            this.handlers.put(channel, value);
            return value;
        }
        catch (IOException failed) {
            handler.onEnd();
            return null;
        }
    }

    @Override
    public void add(Disposable disposable) {
        this._disposables.add(disposable);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this._disposables.remove(disposable);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Disposable schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduler.schedule(command, delay, unit);
    }

    @Override
    public Disposable scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public Disposable scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduler.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<Disposable> list = this._disposables;
        synchronized (list) {
            for (Disposable r : this._disposables.toArray(new Disposable[this._disposables.size()])) {
                r.dispose();
            }
        }
        this.scheduler.dispose();
        this.execute(new Runnable(){

            @Override
            public void run() {
                NioFiberImpl.this.selectorRunning = false;
            }
        });
    }

    @Override
    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        EventBuffer buffer = new EventBuffer();
        while (this.selectorRunning) {
            try {
                int select = this.selector.select();
                if (select > 0) {
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    for (SelectionKey key : selectedKeys) {
                        NioState attachment = (NioState)key.attachment();
                        NioChannelHandler.Result result = this.execEvent(key, attachment);
                        switch (result) {
                            case CloseSocket: {
                                this.closeQuietly(attachment.channel);
                            }
                            case RemoveHandler: {
                                this.handlers.remove(attachment.channel);
                                key.cancel();
                                attachment.onEnd();
                            }
                        }
                    }
                    selectedKeys.clear();
                }
                buffer = this.queue.swap(buffer);
                this.executor.execute(buffer);
                buffer.clear();
            }
            catch (ClosedSelectorException closed) {
                break;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.queue.setRunning(false);
        for (NioState nioState : this.handlers.values()) {
            nioState.onSelectorEnd();
        }
        this.handlers.clear();
        try {
            this.selector.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private NioChannelHandler.Result execEvent(SelectionKey key, NioState attachment) {
        try {
            return attachment.onSelect(this.executor, this, this.controls, key);
        }
        catch (CancelledKeyException invalid) {
            return NioChannelHandler.Result.RemoveHandler;
        }
    }

    public static class NoOpBuffer
    implements OnBuffer {
        @Override
        public <T extends SelectableChannel> void onBufferEnd(T channel) {
        }

        @Override
        public <T extends SelectableChannel> void onBuffer(T channel, ByteBuffer data) {
        }
    }

    public static class NoOpWriteFailure
    implements WriteFailure {
        @Override
        public <T extends SelectableChannel> void onFailure(IOException e, T channel, ByteBuffer data) {
        }
    }

    public static interface WriteFailure {
        public <T extends SelectableChannel> void onFailure(IOException var1, T var2, ByteBuffer var3);
    }

    public static class BufferedWrite<T extends SelectableChannel>
    implements NioChannelHandler {
        private final T channel;
        private final WriteFailure writeFailed;
        private final OnBuffer onBuffer;
        ByteBuffer data;

        public BufferedWrite(T channel, WriteFailure writeFailed, OnBuffer onBuffer) {
            this.channel = channel;
            this.writeFailed = writeFailed;
            this.onBuffer = onBuffer;
        }

        @Override
        public NioChannelHandler.Result onSelect(NioFiber nioFiber, NioControls controls, SelectionKey key) {
            try {
                NioFiberImpl.writeAll((WritableByteChannel)this.channel, this.data);
            }
            catch (IOException e) {
                this.writeFailed.onFailure(e, this.channel, this.data);
                return NioChannelHandler.Result.CloseSocket;
            }
            if (this.data.remaining() < 1) {
                this.onBuffer.onBufferEnd(this.channel);
                return NioChannelHandler.Result.RemoveHandler;
            }
            return NioChannelHandler.Result.Continue;
        }

        @Override
        public SelectableChannel getChannel() {
            return this.channel;
        }

        @Override
        public int getInterestSet() {
            return 4;
        }

        @Override
        public void onEnd() {
        }

        public ByteBuffer getBuffer() {
            return this.data;
        }

        @Override
        public void onSelectorEnd() {
            this.onEnd();
        }

        public int buffer(ByteBuffer buffer) {
            this.data = NioFiberImpl.addTo(this.data, buffer);
            assert (this.data.remaining() > 0) : this.channel + " " + this.data;
            this.onBuffer.onBuffer(this.channel, this.data);
            return this.data.remaining();
        }
    }

    private static class NioStateWrite<T extends SelectableChannel>
    extends BufferedWrite<T> {
        NioState state;

        public NioStateWrite(T channel, WriteFailure writeFailed, OnBuffer onBuffer) {
            super(channel, writeFailed, onBuffer);
        }

        @Override
        public void onEnd() {
            this.state.buffer = null;
            this.state = null;
        }
    }

    private static class NioState {
        private final SelectableChannel channel;
        private final List<NioChannelHandler> handlers = new ArrayList<NioChannelHandler>(1);
        private SelectionKey key;
        public BufferedWrite buffer;

        public NioState(SelectableChannel channel) {
            this.channel = channel;
        }

        public void addToBuffer(ByteBuffer newBytes) {
            this.buffer.buffer(newBytes);
        }

        public void onSelectorEnd() {
            for (NioChannelHandler handler : this.handlers) {
                handler.onSelectorEnd();
            }
        }

        public NioChannelHandler.Result onSelect(NioBatchExecutor exec, NioFiberImpl fiber, NioControls controls, SelectionKey key) {
            int size = this.handlers.size();
            block4: for (int i = 0; i < size; ++i) {
                boolean interested;
                NioChannelHandler handler = this.handlers.get(i);
                boolean bl = interested = (key.readyOps() & handler.getInterestSet()) != 0;
                if (!interested) continue;
                NioChannelHandler.Result result = exec.runOnSelect(fiber, handler, controls, key);
                switch (result) {
                    case RemoveHandler: {
                        if (this.handlers.size() > 1) {
                            this.handlers.remove(i--);
                            handler.onEnd();
                            --size;
                            NioFiberImpl.removeInterestFrom(handler, key);
                            continue block4;
                        }
                        return NioChannelHandler.Result.RemoveHandler;
                    }
                    case CloseSocket: {
                        return NioChannelHandler.Result.CloseSocket;
                    }
                }
            }
            return this.handlers.isEmpty() ? NioChannelHandler.Result.RemoveHandler : NioChannelHandler.Result.Continue;
        }

        public void onEnd() {
            for (NioChannelHandler handler : this.handlers) {
                handler.onEnd();
            }
        }

        public boolean attemptUpdateInterest(int interestSet) {
            try {
                this.key.interestOps(this.key.interestOps() | interestSet);
                return true;
            }
            catch (CancelledKeyException failed) {
                return false;
            }
        }
    }

    public static interface OnBuffer {
        public <T extends SelectableChannel> void onBufferEnd(T var1);

        public <T extends SelectableChannel> void onBuffer(T var1, ByteBuffer var2);
    }
}

