/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.fibers;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.jetlang.core.BatchExecutor;
import org.jetlang.core.BatchExecutorImpl;
import org.jetlang.core.Disposable;
import org.jetlang.core.SchedulerImpl;
import org.jetlang.fibers.Fiber;
import org.jetlang.fibers.PoolFiber;

public class PoolFiberFactory
implements Disposable {
    private final ScheduledExecutorService _scheduler;
    private final Executor executor;

    public PoolFiberFactory(Executor executor, ScheduledExecutorService sched) {
        this.executor = executor;
        this._scheduler = sched;
    }

    public PoolFiberFactory(Executor exec) {
        this(exec, SchedulerImpl.createSchedulerThatIgnoresEventsAfterStop());
    }

    public Fiber create() {
        return this.create(new BatchExecutorImpl());
    }

    public Fiber create(BatchExecutor batchExecutor) {
        return new PoolFiber(this.executor, batchExecutor, this._scheduler);
    }

    @Override
    public void dispose() {
        this._scheduler.shutdown();
    }
}

