/*
 * Decompiled with CFR 0.152.
 */
package org.jetlang.fibers;

import java.util.concurrent.TimeUnit;
import org.jetlang.core.Disposable;
import org.jetlang.core.RunnableExecutor;
import org.jetlang.core.RunnableExecutorImpl;
import org.jetlang.core.Scheduler;
import org.jetlang.core.SchedulerImpl;
import org.jetlang.fibers.Fiber;

public class ThreadFiber
implements Fiber {
    private final Thread _thread;
    private final RunnableExecutor _queue;
    private final Scheduler _scheduler;

    public ThreadFiber(RunnableExecutor queue, String threadName, boolean isDaemonThread, Scheduler scheduler) {
        this._queue = queue;
        Runnable runThread = new Runnable(){

            @Override
            public void run() {
                ThreadFiber.this._queue.run();
            }
        };
        this._thread = this.createThread(threadName, runThread);
        this._thread.setDaemon(isDaemonThread);
        this._scheduler = scheduler;
    }

    public ThreadFiber(RunnableExecutor queue, String threadName, boolean isDaemonThread) {
        this(queue, threadName, isDaemonThread, new SchedulerImpl(queue));
    }

    private Thread createThread(String threadName, Runnable runThread) {
        if (threadName == null) {
            return new Thread(runThread);
        }
        return new Thread(runThread, threadName);
    }

    public ThreadFiber() {
        this(new RunnableExecutorImpl(), null, true);
    }

    public Thread getThread() {
        return this._thread;
    }

    @Override
    public void execute(Runnable command) {
        this._queue.execute(command);
    }

    @Override
    public void add(Disposable runOnStop) {
        this._queue.add(runOnStop);
    }

    @Override
    public boolean remove(Disposable disposable) {
        return this._queue.remove(disposable);
    }

    @Override
    public int size() {
        return this._queue.size();
    }

    @Override
    public void dispose() {
        this._scheduler.dispose();
        this._queue.dispose();
    }

    @Override
    public void start() {
        this._thread.start();
    }

    public void join() throws InterruptedException {
        this._thread.join();
    }

    @Override
    public Disposable schedule(Runnable command, long delay, TimeUnit unit) {
        return this._scheduler.schedule(command, delay, unit);
    }

    @Override
    public Disposable scheduleAtFixedRate(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this._scheduler.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    @Override
    public Disposable scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this._scheduler.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public String toString() {
        return "ThreadFiber{" + this._thread + '}';
    }
}

