/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ConjureCardEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class InitPillarOfTheParunsEffect
extends OneShotEffect {
    private UUID playerId;
    private String cardName;

    InitPillarOfTheParunsEffect(UUID playerId, String cardName) {
        super(Outcome.PutLandInPlay);
        this.playerId = playerId;
        this.cardName = cardName;
        this.staticText = "conjure " + cardName + " in play. It does count as a land played for the turn.";
    }

    private InitPillarOfTheParunsEffect(InitPillarOfTheParunsEffect effect) {
        super((OneShotEffect)effect);
        this.playerId = effect.playerId;
        this.cardName = effect.cardName;
    }

    public InitPillarOfTheParunsEffect copy() {
        return new InitPillarOfTheParunsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.playerId);
        if (player == null) {
            return false;
        }
        new ConjureCardEffect(this.cardName, Zone.BATTLEFIELD, 1).apply(game, source);
        player.incrementLandsPlayed();
        return true;
    }
}

