/*
 * Decompiled with CFR 0.152.
 */
package mage.player.human;

import java.io.Serializable;
import java.util.UUID;
import mage.constants.ManaType;
import mage.game.Game;
import mage.util.Copyable;

public class PlayerResponse
implements Serializable,
Copyable<PlayerResponse> {
    private String activeAction;
    private String activeGameInfo;
    private String responseString;
    private UUID responseUUID;
    private Boolean responseBoolean;
    private Integer responseInteger;
    private ManaType responseManaType;
    private UUID responseManaPlayerId;
    private Boolean asyncWantConcede;
    private Boolean asyncWantCheat;

    public PlayerResponse() {
        this.clear();
    }

    public String toString() {
        return (this.responseString == null ? "null" : this.responseString) + "," + this.responseUUID + "," + this.responseBoolean + "," + this.responseInteger + "," + this.responseManaType + "," + this.responseManaPlayerId + "," + this.asyncWantConcede + "," + this.asyncWantCheat + " (" + (this.activeAction == null ? "sleep" : this.activeAction) + ")";
    }

    protected PlayerResponse(PlayerResponse response) {
        this.copyFrom(response);
    }

    public PlayerResponse copy() {
        return new PlayerResponse(this);
    }

    public void copyFrom(PlayerResponse response) {
        this.activeAction = response.activeAction;
        this.activeGameInfo = response.activeGameInfo;
        this.responseString = response.responseString;
        this.responseUUID = response.responseUUID;
        this.responseBoolean = response.responseBoolean;
        this.responseInteger = response.responseInteger;
        this.responseManaType = response.responseManaType;
        this.responseManaPlayerId = response.responseManaPlayerId;
        this.asyncWantConcede = response.asyncWantConcede;
        this.asyncWantCheat = response.asyncWantCheat;
    }

    public void clear() {
        this.activeAction = null;
        this.activeGameInfo = null;
        this.responseString = null;
        this.responseUUID = null;
        this.responseBoolean = null;
        this.responseInteger = null;
        this.responseManaType = null;
        this.responseManaPlayerId = null;
        this.asyncWantConcede = null;
        this.asyncWantCheat = null;
    }

    public String getActiveAction() {
        return this.activeAction;
    }

    public String getActiveGameInfo() {
        return this.activeGameInfo;
    }

    public void setActiveAction(Game game, String activeAction) {
        this.activeAction = activeAction;
        this.activeGameInfo = game.getId() + ", " + game;
    }

    public String getString() {
        return this.responseString;
    }

    public void setString(String newString) {
        this.responseString = newString;
    }

    public UUID getUUID() {
        return this.responseUUID;
    }

    public void setUUID(UUID newUUID) {
        this.responseUUID = newUUID;
    }

    public Boolean getBoolean() {
        return this.responseBoolean;
    }

    public void setBoolean(Boolean newBoolean) {
        this.responseBoolean = newBoolean;
    }

    public Integer getInteger() {
        return this.responseInteger;
    }

    public void setInteger(Integer newInteger) {
        this.responseInteger = newInteger;
    }

    public ManaType getManaType() {
        return this.responseManaType;
    }

    public void setManaType(ManaType newManaType) {
        this.responseManaType = newManaType;
    }

    public UUID getManaPlayerId() {
        return this.responseManaPlayerId;
    }

    public void setResponseManaPlayerId(UUID newManaPlayerId) {
        this.responseManaPlayerId = newManaPlayerId;
    }

    public Boolean getAsyncWantConcede() {
        return this.asyncWantConcede != null && this.asyncWantConcede != false;
    }

    public void setAsyncWantConcede() {
        this.asyncWantConcede = true;
    }

    public Boolean getAsyncWantCheat() {
        return this.asyncWantCheat != null && this.asyncWantCheat != false;
    }

    public void setAsyncWantCheat() {
        this.asyncWantCheat = true;
    }
}

