/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.keyword.RepairAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPlayer;

public final class AAT1
extends CardImpl {
    public AAT1(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{1}{W}{U}{B}");
        this.subtype.add((Object)SubType.DROID);
        this.subtype.add((Object)SubType.CONSTRUCT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);
        DoIfCostPaid effect = new DoIfCostPaid((Effect)new LoseLifeTargetEffect(1), (Cost)new ManaCostsImpl("{W/B}"));
        GainLifeEffect additionalEffect = new GainLifeEffect(1);
        additionalEffect.setText("and you gain 1 life");
        effect.addEffect((Effect)additionalEffect);
        AAT1TriggeredAbility ability = new AAT1TriggeredAbility((Effect)effect);
        ability.addTarget((Target)new TargetPlayer());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new RepairAbility(4));
    }

    private AAT1(AAT1 card) {
        super((CardImpl)card);
    }

    public AAT1 copy() {
        return new AAT1(this);
    }

    private static class AAT1TriggeredAbility
    extends TriggeredAbilityImpl {
        public AAT1TriggeredAbility(Effect effect) {
            super(Zone.BATTLEFIELD, effect);
            this.setTriggerPhrase("Whenever a repair counter is removed from a creature card in your graveyard ");
        }

        private AAT1TriggeredAbility(AAT1TriggeredAbility ability) {
            super((TriggeredAbilityImpl)ability);
        }

        public boolean checkEventType(GameEvent event, Game game) {
            return event.getType() == GameEvent.EventType.COUNTER_REMOVED;
        }

        public boolean checkTrigger(GameEvent event, Game game) {
            Card card = game.getCard(event.getTargetId());
            return card != null && card.getOwnerId().equals(game.getControllerId(this.sourceId)) && card.isCreature(game) && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && event.getData().equals(CounterType.REPAIR.getName());
        }

        public AAT1TriggeredAbility copy() {
            return new AAT1TriggeredAbility(this);
        }
    }
}

