/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AWingAttacksNextCombatIfAbleSourceEffect
extends RequirementEffect {
    int turnNumber;
    int phaseCount;
    int nextPhaseTurnNumber = 0;
    int nextPhasePhaseCount = 0;

    public AWingAttacksNextCombatIfAbleSourceEffect() {
        super(Duration.Custom);
        this.staticText = "It must attack on your next combat if able";
    }

    private AWingAttacksNextCombatIfAbleSourceEffect(AWingAttacksNextCombatIfAbleSourceEffect effect) {
        super((RequirementEffect)effect);
        this.turnNumber = effect.turnNumber;
        this.phaseCount = effect.phaseCount;
        this.nextPhaseTurnNumber = effect.nextPhaseTurnNumber;
        this.nextPhasePhaseCount = effect.nextPhasePhaseCount;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.turnNumber = game.getTurnNum();
        this.phaseCount = game.getPhase().getCount();
    }

    public AWingAttacksNextCombatIfAbleSourceEffect copy() {
        return new AWingAttacksNextCombatIfAbleSourceEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId()) && (game.getTurnNum() != this.turnNumber || game.getPhase().getCount() != this.phaseCount)) {
            if (this.nextPhaseTurnNumber == 0) {
                this.nextPhasePhaseCount = game.getPhase().getCount();
                this.nextPhaseTurnNumber = game.getTurnNum();
            } else if (game.getTurnNum() != this.nextPhaseTurnNumber || game.getPhase().getCount() != this.nextPhasePhaseCount) {
                this.discard();
            }
            return true;
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

