/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AbattoirGhoulEffect
extends OneShotEffect {
    AbattoirGhoulEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to that creature's toughness";
    }

    private AbattoirGhoulEffect(AbattoirGhoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbattoirGhoulEffect copy() {
        return new AbattoirGhoulEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (creature != null) {
            int toughness = creature.getToughness().getValue();
            if (controller != null) {
                controller.gainLife(toughness, game, source);
                return true;
            }
        }
        return false;
    }
}

