/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AbundantHarvestEffect
extends OneShotEffect {
    AbundantHarvestEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose land or nonland. Reveal cards from the top of your library until you reveal a card of the chosen kind. Put that card into your hand and the rest on the bottom of your library in a random order.";
    }

    private AbundantHarvestEffect(AbundantHarvestEffect effect) {
        super((OneShotEffect)effect);
    }

    public AbundantHarvestEffect copy() {
        return new AbundantHarvestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean land = player.chooseUse(Outcome.Neutral, "Choose land or nonland", null, "Land", "Nonland", source, game);
        CardsImpl toReveal = new CardsImpl();
        Card toHand = null;
        for (Card card : player.getLibrary().getCards(game)) {
            if (card == null) continue;
            toReveal.add(card);
            if (card.isLand(game) != land) continue;
            toHand = card;
            break;
        }
        player.revealCards(source, (Cards)toReveal, game);
        if (toHand != null) {
            toReveal.remove(toHand);
            player.moveCards(toHand, Zone.HAND, source, game);
        }
        player.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }
}

