/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.cost.SpellsCostIncreasingAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class AcademyLoremasterEffect
extends OneShotEffect {
    AcademyLoremasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may draw an additional card. If they do, spells they cast this turn cost {2} more to cast";
    }

    private AcademyLoremasterEffect(AcademyLoremasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public AcademyLoremasterEffect copy() {
        return new AcademyLoremasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null || !player.chooseUse(this.outcome, "Draw an additional card?", source, game) || player.drawCards(1, source, game) < 1) {
            return false;
        }
        game.addEffect((ContinuousEffect)new SpellsCostIncreasingAllEffect(2, StaticFilters.FILTER_CARD, TargetController.ACTIVE).setDuration(Duration.EndOfTurn), source);
        return true;
    }
}

