/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Iterator;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.CreateTokenEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.token.ClueArtifactToken;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class AcademyManufactorEffect
extends ReplacementEffectImpl {
    AcademyManufactorEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you would create a Clue, Food, or Treasure token, instead create one of each";
    }

    private AcademyManufactorEffect(AcademyManufactorEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AcademyManufactorEffect copy() {
        return new AcademyManufactorEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATE_TOKEN;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!(event instanceof CreateTokenEvent) || !event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        for (Token token : ((CreateTokenEvent)event).getTokens().keySet()) {
            if (!token.hasSubtype(SubType.CLUE, game) && !token.hasSubtype(SubType.FOOD, game) && !token.hasSubtype(SubType.TREASURE, game)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount = 0;
        Map tokens = ((CreateTokenEvent)event).getTokens();
        Iterator iter = tokens.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Token token = (Token)entry.getKey();
            if (!token.hasSubtype(SubType.CLUE, game) && !token.hasSubtype(SubType.FOOD, game) && !token.hasSubtype(SubType.TREASURE, game)) continue;
            amount += ((Integer)entry.getValue()).intValue();
            iter.remove();
        }
        tokens.put(new ClueArtifactToken(), amount);
        tokens.put(new FoodToken(), amount);
        tokens.put(new TreasureToken(), amount);
        return false;
    }
}

