/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class AccursedWitchReturnTransformedEffect
extends OneShotEffect {
    AccursedWitchReturnTransformedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield transformed under your control attached to target opponent";
    }

    private AccursedWitchReturnTransformedEffect(AccursedWitchReturnTransformedEffect effect) {
        super((OneShotEffect)effect);
    }

    public AccursedWitchReturnTransformedEffect copy() {
        return new AccursedWitchReturnTransformedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player attachTo = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || game.getState().getZone(source.getSourceId()) != Zone.GRAVEYARD || attachTo == null) {
            return false;
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + source.getSourceId(), (Object)Boolean.TRUE);
        game.getState().setValue("attachTo:" + source.getSourceId(), (Object)attachTo.getId());
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            attachTo.addAttachment(card.getId(), source, game);
        }
        return true;
    }
}

