/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AcolyteHybridEffect
extends OneShotEffect {
    AcolyteHybridEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy up to one target artifact. If an artifact is destroyed this way, its controller draws a card";
    }

    private AcolyteHybridEffect(AcolyteHybridEffect effect) {
        super((OneShotEffect)effect);
    }

    public AcolyteHybridEffect copy() {
        return new AcolyteHybridEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || !permanent.destroy(source, game)) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

