/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.DevotionCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class AcolytesRewardEffect
extends PreventionEffectImpl {
    protected int amount = 0;

    AcolytesRewardEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "Prevent the next X damage that would be dealt to target creature this turn, where X is your devotion to white. If damage is prevented this way, {this} deals that much damage to any target";
    }

    private AcolytesRewardEffect(AcolytesRewardEffect effect) {
        super((PreventionEffectImpl)effect);
        this.amount = effect.amount;
    }

    public AcolytesRewardEffect copy() {
        return new AcolytesRewardEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.amount = DevotionCount.W.calculate(game, source, (Effect)this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        boolean result = false;
        int toPrevent = this.amount;
        if (event.getAmount() < this.amount) {
            toPrevent = event.getAmount();
            this.amount -= event.getAmount();
        } else {
            this.amount = 0;
        }
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), toPrevent, ((DamageEvent)event).isCombatDamage());
        if (game.replaceEvent((GameEvent)preventEvent)) {
            return result;
        }
        Permanent targetCreature = game.getPermanent(event.getTargetId());
        if (targetCreature == null) {
            return result;
        }
        if (this.amount == 0) {
            this.used = true;
            this.discard();
        }
        if (event.getAmount() >= toPrevent) {
            event.setAmount(event.getAmount() - toPrevent);
        } else {
            event.setAmount(0);
            result = true;
        }
        if (toPrevent == 0) {
            return result;
        }
        game.informPlayers("Acolyte's Reward prevented " + toPrevent + " to " + targetCreature.getName());
        game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), toPrevent));
        Player targetPlayer = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (targetPlayer != null) {
            targetPlayer.damage(toPrevent, source.getSourceId(), source, game);
            game.informPlayers("Acolyte's Reward deals " + toPrevent + " damage to " + targetPlayer.getLogName());
            return result;
        }
        Permanent targetDamageCreature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (targetDamageCreature == null) {
            return result;
        }
        targetDamageCreature.damage(toPrevent, source.getSourceId(), source, game, false, true);
        game.informPlayers("Acolyte's Reward deals " + toPrevent + " damage to " + targetDamageCreature.getName());
        return result;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.used && super.applies(event, source, game) && event.getTargetId().equals(source.getFirstTarget());
    }
}

