/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class AcquisitionOctopusTriggeredAbility
extends TriggeredAbilityImpl {
    AcquisitionOctopusTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
    }

    private AcquisitionOctopusTriggeredAbility(AcquisitionOctopusTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AcquisitionOctopusTriggeredAbility copy() {
        return new AcquisitionOctopusTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!((DamagedEvent)event).isCombatDamage()) {
            return false;
        }
        if (this.getSourceId().equals(event.getSourceId())) {
            return true;
        }
        Permanent permanent = this.getSourcePermanentOrLKI(game);
        return permanent != null && event.getSourceId().equals(permanent.getAttachedTo());
    }

    public String getRule() {
        return "Whenever {this} or equipped creature deals combat damage to a player, draw a card.";
    }
}

