/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class AegarTheFreezingFlameWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> playerMap = new HashMap<UUID, Set<MageObjectReference>>();
    private static final Set<MageObjectReference> emptySet = new HashSet<MageObjectReference>();

    AegarTheFreezingFlameWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        MageObject sourceObject = game.getObject(event.getSourceId());
        if (sourceObject == null) {
            return;
        }
        if (game.getSpellOrLKIStack(event.getSourceId()) == null && !sourceObject.hasSubtype(SubType.GIANT, game) && !sourceObject.hasSubtype(SubType.WIZARD, game)) {
            return;
        }
        this.playerMap.computeIfAbsent(game.getControllerId(event.getSourceId()), x -> new HashSet()).add(new MageObjectReference(event.getTargetId(), game));
    }

    boolean checkDamage(UUID playerId, UUID targetId, Game game) {
        return this.playerMap.getOrDefault(playerId, emptySet).contains(new MageObjectReference(targetId, game));
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }
}

