/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class AetherRefineryEffect
extends ReplacementEffectImpl {
    AetherRefineryEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, false);
        this.staticText = "If you would get one or more {E}, you get twice that many {E} instead";
    }

    private AetherRefineryEffect(AetherRefineryEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowMultiply((int)event.getAmount(), (int)2), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getData().equals(CounterType.ENERGY.getName()) && event.getAmount() > 0) {
            return source.getControllerId() == event.getPlayerId();
        }
        return false;
    }

    public AetherRefineryEffect copy() {
        return new AetherRefineryEffect(this);
    }
}

