/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.token.AetherbornToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class AetherRefineryTokenEffect
extends OneShotEffect {
    AetherRefineryTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may pay one or more {E}. If you do, create an X/X black Aetherborn creature token, where X is the amount of {E} paid this way";
    }

    private AetherRefineryTokenEffect(AetherRefineryTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherRefineryTokenEffect copy() {
        return new AetherRefineryTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int totalEnergy = controller.getCountersCount(CounterType.ENERGY);
            if (totalEnergy == 0) {
                return false;
            }
            if (!controller.chooseUse(this.getOutcome(), "Pay 1 or more {E} to create X/X black Aetherborn creature token", source, game)) {
                return true;
            }
            int numberToPay = controller.getAmount(1, totalEnergy, "Pay one or more {E}", source, game);
            PayEnergyCost cost = new PayEnergyCost(numberToPay);
            if (cost.pay(source, game, source, source.getControllerId(), true)) {
                new CreateTokenEffect((Token)new AetherbornToken(numberToPay, numberToPay)).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

