/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class AetherbornMarauderEffect
extends OneShotEffect {
    AetherbornMarauderEffect() {
        super(Outcome.Benefit);
        this.staticText = "move any number of +1/+1 counters from other permanents you control onto {this}";
    }

    private AetherbornMarauderEffect(AetherbornMarauderEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherbornMarauderEffect copy() {
        return new AetherbornMarauderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (controller != null && sourceObject != null) {
            FilterControlledPermanent filter = new FilterControlledPermanent("permanent you control to remove +1/+1 counters from");
            filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
            filter.add((Predicate)CounterType.P1P1.getPredicate());
            boolean firstRun = true;
            while (game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) > 0 && controller.chooseUse(this.outcome, "Move " + (firstRun ? "any" : "more") + " +1/+1 counters from other permanents you control to " + sourceObject.getLogName() + '?', source, game)) {
                Permanent fromPermanent;
                firstRun = false;
                TargetControlledPermanent target = new TargetControlledPermanent(filter);
                target.withNotTarget(true);
                if (!target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game) || (fromPermanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                int numberOfCounters = fromPermanent.getCounters(game).getCount(CounterType.P1P1);
                int numberToMove = 1;
                if (numberOfCounters > 1) {
                    numberToMove = controller.getAmount(0, numberOfCounters, "Choose how many +1/+1 counters to move", source, game);
                }
                if (numberToMove <= 0) continue;
                fromPermanent.removeCounters(CounterType.P1P1.createInstance(numberToMove), source, game);
                sourceObject.addCounters(CounterType.P1P1.createInstance(numberToMove), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

