/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Optional;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.stack.Spell;

class AetherfluxConduitManaEffect
extends OneShotEffect {
    AetherfluxConduitManaEffect() {
        super(Outcome.Benefit);
        this.staticText = "you get an amount of {E} <i>(energy counters)</i> equal to the amount of mana spent to cast that spell";
    }

    private AetherfluxConduitManaEffect(AetherfluxConduitManaEffect effect) {
        super((OneShotEffect)effect);
    }

    public AetherfluxConduitManaEffect copy() {
        return new AetherfluxConduitManaEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        int amount = Optional.ofNullable(this.getValue("spellCast")).map(Spell.class::cast).map(Spell::getStackAbility).map(Ability::getManaCostsToPay).map(ManaCost::getUsedManaToPay).map(Mana::count).orElse(0);
        if (amount <= 0) return false;
        if (!Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> player.addCounters(CounterType.ENERGY.createInstance(amount), player.getId(), source, game)).isPresent()) return false;
        return true;
    }
}

