/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.DidNotAttackThisTurnEnchantedCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DestroyAttachedToEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class Aggression
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("non-Wall creature");

    public Aggression(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent((FilterPermanent)filter);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)FirstStrikeAbility.getInstance(), AttachmentType.AURA));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)TrampleAbility.getInstance(), AttachmentType.AURA).setText("and trample"));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new BeginningOfEndStepTriggeredAbility(TargetController.CONTROLLER_ATTACHED_TO, (Effect)new ConditionalOneShotEffect((OneShotEffect)new DestroyAttachedToEffect(""), (Condition)DidNotAttackThisTurnEnchantedCondition.instance, "destroy that creature if it didn't attack this turn"), false));
    }

    private Aggression(Aggression card) {
        super((CardImpl)card);
    }

    public Aggression copy() {
        return new Aggression(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.WALL.getPredicate()));
    }
}

