/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class AgitatorAntEffect
extends OneShotEffect {
    AgitatorAntEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may put two +1/+1 counters on a creature they control. Goad each creature that had counters put on it this way.";
    }

    private AgitatorAntEffect(AgitatorAntEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgitatorAntEffect copy() {
        return new AgitatorAntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Player player : game.getState().getPlayersInRange(source.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toList())) {
            if (game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), game) < 1 || !player.chooseUse(Outcome.BoostCreature, "Put two +1/+1 counters on a creature you control?", source, game)) continue;
            TargetControlledCreaturePermanent targetPermanent = new TargetControlledCreaturePermanent(0, 1);
            targetPermanent.withNotTarget(true);
            player.choose(Outcome.BoostCreature, (Target)targetPermanent, source, game);
            Permanent permanent = game.getPermanent(targetPermanent.getFirstTarget());
            if (permanent == null || !permanent.addCounters(CounterType.P1P1.createInstance(2), player.getId(), source, game)) continue;
            game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

