/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class AgonizingRemorseEffect
extends OneShotEffect {
    AgonizingRemorseEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals their hand. You choose a nonland card from it or a card from their graveyard. Exile that card. You lose 1 life.";
    }

    private AgonizingRemorseEffect(AgonizingRemorseEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgonizingRemorseEffect copy() {
        return new AgonizingRemorseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Cards cards;
        TargetCard target;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        opponent.revealCards(source, opponent.getHand(), game);
        if (controller.chooseUse(this.outcome, "Exile a card from hand or graveyard?", null, "Hand", "Graveyard", source, game)) {
            target = new TargetCard(Zone.HAND, (FilterCard)new FilterNonlandCard("nonland card in " + opponent.getName() + "'s hand"));
            target.withNotTarget(true);
            cards = opponent.getHand();
        } else {
            target = new TargetCard(Zone.GRAVEYARD, new FilterCard("card in " + opponent.getName() + "'s graveyard"));
            target.withNotTarget(true);
            cards = opponent.getGraveyard();
        }
        if (controller.choose(this.outcome, cards, target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        controller.loseLife(1, game, source, false);
        return true;
    }
}

