/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AgrusKosSpiritOfJusticeEffect
extends OneShotEffect {
    AgrusKosSpiritOfJusticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target creature. If it's suspected, exile it. Otherwise, suspect it";
    }

    private AgrusKosSpiritOfJusticeEffect(AgrusKosSpiritOfJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AgrusKosSpiritOfJusticeEffect copy() {
        return new AgrusKosSpiritOfJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        if (!permanent.isSuspected()) {
            permanent.setSuspected(true, game, source);
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        return player != null && player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

